/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;

public class PluginParamsDefinition {
    private final boolean isDefined;
    private final List<Param> params = new ArrayList<Param>();

    public static PluginParamsDefinition undefined() {
        return new PluginParamsDefinition(false);
    }

    public PluginParamsDefinition() {
        this(true);
    }

    PluginParamsDefinition(boolean isDefined) {
        this.isDefined = isDefined;
    }

    public PluginParamsDefinition add(String name, PluginParamType type, String description, String example) {
        this.add(new Param(name, type, description, example, false));
        return this;
    }

    public PluginParamsDefinition add(String name, PluginParamType type, String description) {
        this.add(new Param(name, type, description, type.example(), false));
        return this;
    }

    public PluginParamsDefinition addRequired(String name, PluginParamType type, String description, String example) {
        this.add(new Param(name, type, description, example, true));
        return this;
    }

    public PluginParamsDefinition add(PluginParamsDefinition paramsDefinition) {
        paramsDefinition.params.forEach(this::add);
        return this;
    }

    private void add(Param param) {
        this.validateNameUniqueness(param.name);
        this.params.add(param);
    }

    private void validateNameUniqueness(String name) {
        boolean found = this.params.stream().anyMatch(p -> ((Param)p).name.equals(name));
        if (found) {
            throw new IllegalArgumentException("parameter <" + name + "> is already registered");
        }
    }

    private Param findParam(String name) {
        return this.params.stream().filter(p -> ((Param)p).name.equals(name)).findFirst().orElse(null);
    }

    public void validate(PluginParams pluginParams) {
        if (!this.isDefined) {
            return;
        }
        ArrayList<String> unrecognizedNames = new ArrayList<String>();
        ArrayList<String> typeMismatches = new ArrayList<String>();
        List<String> missingRequiredNames = this.params.stream().filter(Param::isRequired).filter(p -> !pluginParams.getOpts().has(((Param)p).name)).map(Param::getName).collect(Collectors.toList());
        pluginParams.getOpts().forEach((name, value) -> {
            if (name.equals("meta")) {
                return;
            }
            Param param = this.findParam((String)name);
            if (param == null) {
                unrecognizedNames.add((String)name);
            } else {
                boolean isTypeMatch = param.type.isValid(value);
                if (!isTypeMatch) {
                    typeMismatches.add(name + " given: " + this.renderGiven(value) + ", expected: " + param.type.descriptionWithExample());
                }
            }
        });
        if (unrecognizedNames.isEmpty() && typeMismatches.isEmpty() && missingRequiredNames.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException(this.renderValidationMessage(missingRequiredNames, unrecognizedNames, typeMismatches));
    }

    private String renderGiven(Object value) {
        if (value instanceof String) {
            return "\"" + value + "\" <string>";
        }
        if (value instanceof Boolean) {
            return value + " <boolean>";
        }
        if (value instanceof Number) {
            return value + " <number>";
        }
        return value.toString();
    }

    private String renderValidationMessage(List<String> missingRequiredNames, List<String> unrecognizedNames, List<String> typeMismatches) {
        StringBuilder message = new StringBuilder();
        if (!missingRequiredNames.isEmpty()) {
            message.append("missing required parameter(s): ").append(String.join((CharSequence)", ", missingRequiredNames)).append("\n");
        }
        if (!unrecognizedNames.isEmpty()) {
            message.append("unrecognized parameter(s): ").append(String.join((CharSequence)", ", unrecognizedNames)).append("\n");
        }
        if (!typeMismatches.isEmpty()) {
            message.append("type mismatches:\n  ");
            message.append(String.join((CharSequence)"\n  ", typeMismatches));
            message.append("\n");
        }
        message.append("\navailable plugin parameters:\n");
        this.params.stream().sorted(Comparator.comparing(p -> ((Param)p).name)).forEach(param -> message.append("  ").append(param).append("\n"));
        return message.toString();
    }

    public String toString() {
        return this.params.stream().map(Param::toString).collect(Collectors.joining("\n"));
    }

    static class Param {
        private final String name;
        private final String description;
        private final String example;
        private final PluginParamType type;
        private final boolean isRequired;

        Param(String name, PluginParamType type, String description, String example, boolean isRequired) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.example = example;
            this.isRequired = isRequired;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public String toString() {
            return this.name + ": " + (this.isRequired ? "REQUIRED " : "") + this.description + " <" + this.type.description() + "> (e.g. " + this.example + ")";
        }
    }
}

