/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.image.RectCoord;
import org.testingisdocumenting.znai.extensions.image.ShapeColorAnalyzer;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.utils.StringUtils;
import znaishaded.org.apache.commons.csv.CSVFormat;
import znaishaded.org.apache.commons.csv.CSVParser;
import znaishaded.org.apache.commons.csv.CSVRecord;

class CsvAnnotations {
    private static final int RECT_ARROW_TEXT_POS_IDX = 5;
    private final ShapeColorAnalyzer shapeColorAnalyzer;
    private int badgeNumber;
    private final NumberFormat numberFormat;
    private final MarkdownParser markdownParser;
    private final Path markupPath;

    CsvAnnotations(MarkdownParser markdownParser, Path markupPath, BufferedImage image, Double pixelRatio) {
        this.markdownParser = markdownParser;
        this.markupPath = markupPath;
        this.shapeColorAnalyzer = new ShapeColorAnalyzer(image, pixelRatio);
        this.badgeNumber = 1;
        this.numberFormat = NumberFormat.getNumberInstance();
    }

    List<Map<String, Object>> annotationsShapesFromCsv(String csvContent) {
        ArrayList<Map<String, Object>> annotations = new ArrayList<Map<String, Object>>();
        try (CSVParser csvRecords = CsvAnnotations.readCsvRecords(csvContent);){
            for (CSVRecord record : csvRecords) {
                Map<String, Object> annotation = this.createAnnotation(record);
                annotations.add(annotation);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return annotations;
    }

    private Map<String, Object> createAnnotation(CSVRecord record) {
        String xCoordOrType = record.get(0);
        if (StringUtils.isNumeric(this.numberFormat, xCoordOrType)) {
            return this.createBadge(record);
        }
        switch (xCoordOrType) {
            case "arrow": {
                return this.createArrow(record);
            }
            case "rect": {
                return this.createRect(record);
            }
        }
        throw new IllegalArgumentException("unsupported annotation type: " + xCoordOrType);
    }

    private Map<String, Object> createBadge(CSVRecord record) {
        String xText = record.get(0);
        String yText = record.get(1);
        HashMap<String, Object> badge = new HashMap<String, Object>();
        badge.put("type", "badge");
        Double x = CsvAnnotations.toNum(xText);
        Double y = CsvAnnotations.toNum(yText);
        badge.put("x", x);
        badge.put("y", y);
        badge.put("text", String.valueOf(this.badgeNumber));
        badge.put("invertedColors", this.shapeColorAnalyzer.isDarkCoordinate(x, y));
        ++this.badgeNumber;
        return badge;
    }

    private Map<String, Object> createArrow(CSVRecord record) {
        Map<String, Object> arrow = this.createArrowRectBaseMap("arrow", record);
        RectCoord rectCoord = new RectCoord(record);
        arrow.putAll(rectCoord.toMap());
        arrow.put("invertedColors", this.shapeColorAnalyzer.isDarkBasedOnOppositeCorners(rectCoord));
        return arrow;
    }

    private Map<String, Object> createRect(CSVRecord record) {
        Map<String, Object> rect = this.createArrowRectBaseMap("rect", record);
        RectCoord rectCoord = new RectCoord(record);
        rect.putAll(rectCoord.toMap());
        rect.put("invertedColors", this.shapeColorAnalyzer.isDarkBasedOnAllCorners(rectCoord));
        return rect;
    }

    private Map<String, Object> createArrowRectBaseMap(String type, CSVRecord record) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        if (record.isSet(5)) {
            String markdown = record.get(5).trim();
            MarkupParserResult parserResult = this.markdownParser.parse(this.markupPath, markdown);
            map.put("tooltip", parserResult.getDocElement().contentToListOfMaps());
        }
        return map;
    }

    private static Double toNum(String text) {
        if (text.isEmpty()) {
            return 0.0;
        }
        return Double.parseDouble(text);
    }

    private static CSVParser readCsvRecords(String content) {
        try {
            return CSVFormat.RFC4180.withIgnoreSurroundingSpaces().withIgnoreEmptyLines().withTrim().withDelimiter(',').parse(new StringReader(content));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

