/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.image;

import java.awt.image.BufferedImage;

public class ImageUtils {
    private ImageUtils() {
    }

    public static double colorDarknessRatio(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return 1.0 - (0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue) / 255.0;
    }

    public static double colorDarknessRatio(BufferedImage image, int x, int y, int sampleSize) {
        int halfSample = sampleSize / 2;
        return ImageUtils.colorDarknessRatio(image, x - halfSample, y - halfSample, x + halfSample, y + halfSample);
    }

    public static double colorDarknessRatio(BufferedImage image, int x1, int y1, int x2, int y2) {
        x1 = Math.max(0, x1);
        y1 = Math.max(0, y1);
        x1 = Math.min(x1, image.getWidth() - 1);
        y1 = Math.min(y1, image.getHeight() - 1);
        x2 = Math.min(x2, image.getWidth() - 1);
        y2 = Math.min(y2, image.getHeight() - 1);
        BufferedImage subImage = image.getSubimage(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        return ImageUtils.colorDarknessRatio(subImage);
    }

    public static double colorDarknessRatio(BufferedImage image) {
        int[] colors = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        double ratioSum = 0.0;
        for (int rgb : colors) {
            ratioSum += ImageUtils.colorDarknessRatio(rgb);
        }
        return ratioSum / (double)colors.length;
    }
}

