/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.inlinedcode;

import java.nio.file.Path;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class IdentifierInlinedCodePlugin
implements InlinedCodePlugin {
    private String identifier;
    private String validationPath;

    @Override
    public String id() {
        return "identifier";
    }

    @Override
    public InlinedCodePlugin create() {
        return new IdentifierInlinedCodePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams) {
        this.identifier = pluginParams.getFreeParam();
        this.validationPath = pluginParams.getOpts().getRequiredString("validationPath");
        String validationContent = componentsRegistry.resourceResolver().textContent(this.validationPath);
        this.validate(validationContent, this.identifier);
        return PluginResult.docElement("InlinedCode", Collections.singletonMap("code", this.identifier));
    }

    private void validate(String validationContent, String identifier) {
        Pattern pattern = Pattern.compile("\\b" + identifier + "\\b", 8);
        Matcher matcher = pattern.matcher(validationContent);
        if (!matcher.find()) {
            throw new RuntimeException("can't find <" + identifier + "> identifier in: " + this.validationPath);
        }
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(componentsRegistry.resourceResolver().fullPath(this.validationPath)));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.identifier);
    }
}

