/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UniqueAnchorIdGenerator {
    private final List<LevelId> headings = new ArrayList<LevelId>();
    private final Map<String, Integer> usedHeadingsCount = new HashMap<String, Integer>();
    private Path previousPath;

    public void registerSectionOrSubHeading(Path path, Integer level, String id) {
        this.clearHeadingsOnPathChange(path);
        this.headings.removeIf(levelId -> ((LevelId)levelId).level >= level);
        this.previousPath = path;
        this.headings.add(new LevelId(level, id));
    }

    public String generateId(Path path, String nonUniqueId) {
        Integer count;
        this.clearHeadingsOnPathChange(path);
        String prefix = this.headings.stream().map(LevelId::getId).filter(id -> !id.isEmpty()).collect(Collectors.joining("-"));
        if (!nonUniqueId.isEmpty()) {
            prefix = prefix + (prefix.isEmpty() ? nonUniqueId : "-" + nonUniqueId);
        }
        if ((count = this.usedHeadingsCount.get(prefix)) == null) {
            this.usedHeadingsCount.put(prefix, 1);
            return prefix;
        }
        this.usedHeadingsCount.put(prefix, count + 1);
        return prefix + "-" + (count + 1);
    }

    private void clearHeadingsOnPathChange(Path path) {
        if (!path.equals(this.previousPath)) {
            this.headings.clear();
            this.usedHeadingsCount.clear();
        }
        this.previousPath = path;
    }

    static class LevelId {
        private final Integer level;
        private final String id;

        public LevelId(Integer level, String id) {
            this.level = level;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

