/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.keyword.validator.draftv4;

import java.util.LinkedHashSet;
import java.util.Set;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.collect.ImmutableSet;
import znaishaded.com.google.common.collect.Sets;

public final class RequiredKeywordValidator
extends AbstractKeywordValidator {
    private final Set<String> required;

    public RequiredKeywordValidator(JsonNode digest) {
        super("required");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode element : digest.get(this.keyword)) {
            builder.add(element.textValue());
        }
        this.required = builder.build();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        LinkedHashSet<String> set = Sets.newLinkedHashSet(this.required);
        set.removeAll(Sets.newHashSet(data.getInstance().getNode().fieldNames()));
        if (!set.isEmpty()) {
            report.error(this.newMsg(data, bundle, "err.common.object.missingMembers").put("required", this.required).putArgument("missing", RequiredKeywordValidator.toArrayNode(set)));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.required.size() + " properties";
    }
}

