/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.uritemplate.parse;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Map;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.load.MessageBundles;
import znaishaded.com.github.fge.uritemplate.URITemplateMessageBundle;
import znaishaded.com.github.fge.uritemplate.URITemplateParseException;
import znaishaded.com.github.fge.uritemplate.expression.ExpressionType;
import znaishaded.com.github.fge.uritemplate.expression.TemplateExpression;
import znaishaded.com.github.fge.uritemplate.expression.URITemplateExpression;
import znaishaded.com.github.fge.uritemplate.parse.TemplateParser;
import znaishaded.com.github.fge.uritemplate.parse.VariableSpecParser;
import znaishaded.com.github.fge.uritemplate.vars.specs.VariableSpec;
import znaishaded.com.google.common.base.CharMatcher;
import znaishaded.com.google.common.collect.ImmutableMap;
import znaishaded.com.google.common.collect.Lists;

final class ExpressionParser
implements TemplateParser {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(URITemplateMessageBundle.class);
    private static final Map<Character, ExpressionType> EXPRESSION_TYPE_MAP;
    private static final CharMatcher COMMA;
    private static final CharMatcher END_EXPRESSION;

    ExpressionParser() {
    }

    @Override
    public URITemplateExpression parse(CharBuffer buffer) throws URITemplateParseException {
        buffer.get();
        if (!buffer.hasRemaining()) {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.unexpectedEOF"), buffer, true);
        }
        ExpressionType type = ExpressionType.SIMPLE;
        char c = buffer.charAt(0);
        if (EXPRESSION_TYPE_MAP.containsKey(Character.valueOf(c))) {
            type = EXPRESSION_TYPE_MAP.get(Character.valueOf(buffer.get()));
        }
        ArrayList<VariableSpec> varspecs = Lists.newArrayList();
        do {
            varspecs.add(VariableSpecParser.parse(buffer));
            if (buffer.hasRemaining()) continue;
            throw new URITemplateParseException(BUNDLE.getMessage("parse.unexpectedEOF"), buffer, true);
        } while (COMMA.matches(c = buffer.get()));
        if (!END_EXPRESSION.matches(c)) {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.unexpectedToken"), buffer, true);
        }
        return new TemplateExpression(type, varspecs);
    }

    static {
        COMMA = CharMatcher.is(',');
        END_EXPRESSION = CharMatcher.is('}');
        ImmutableMap.Builder<Character, ExpressionType> builder = ImmutableMap.builder();
        char c = '+';
        ExpressionType type = ExpressionType.RESERVED;
        builder.put(Character.valueOf(c), type);
        c = '#';
        type = ExpressionType.FRAGMENT;
        builder.put(Character.valueOf(c), type);
        c = '.';
        type = ExpressionType.NAME_LABELS;
        builder.put(Character.valueOf(c), type);
        c = '/';
        type = ExpressionType.PATH_SEGMENTS;
        builder.put(Character.valueOf(c), type);
        c = ';';
        type = ExpressionType.PATH_PARAMETERS;
        builder.put(Character.valueOf(c), type);
        c = '?';
        type = ExpressionType.QUERY_STRING;
        builder.put(Character.valueOf(c), type);
        c = '&';
        type = ExpressionType.QUERY_CONT;
        builder.put(Character.valueOf(c), type);
        EXPRESSION_TYPE_MAP = builder.build();
    }
}

