/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.file;

import java.io.File;
import znaishaded.io.vertx.codegen.annotations.DataObject;
import znaishaded.io.vertx.core.file.FileSystemOptionsConverter;
import znaishaded.io.vertx.core.json.JsonObject;

@DataObject(generateConverter=true, publicConverter=false)
public class FileSystemOptions {
    public static final boolean DEFAULT_FILE_CACHING_ENABLED = !Boolean.getBoolean("vertx.disableFileCaching");
    public static final boolean DEFAULT_CLASS_PATH_RESOLVING_ENABLED = !Boolean.getBoolean("vertx.disableFileCPResolving");
    private static final String TMPDIR = System.getProperty("java.io.tmpdir", ".");
    private static final String DEFAULT_CACHE_DIR_BASE = "vertx-cache";
    public static final String DEFAULT_FILE_CACHING_DIR = System.getProperty("vertx.cacheDirBase", TMPDIR + File.separator + "vertx-cache");
    private boolean classPathResolvingEnabled = DEFAULT_CLASS_PATH_RESOLVING_ENABLED;
    private boolean fileCachingEnabled = DEFAULT_FILE_CACHING_ENABLED;
    private String fileCacheDir = DEFAULT_FILE_CACHING_DIR;

    public FileSystemOptions() {
    }

    public FileSystemOptions(FileSystemOptions other) {
        this.classPathResolvingEnabled = other.isClassPathResolvingEnabled();
        this.fileCachingEnabled = other.isFileCachingEnabled();
        this.fileCacheDir = other.getFileCacheDir();
    }

    public FileSystemOptions(JsonObject json) {
        this();
        FileSystemOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        FileSystemOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isClassPathResolvingEnabled() {
        return this.classPathResolvingEnabled;
    }

    public FileSystemOptions setClassPathResolvingEnabled(boolean classPathResolvingEnabled) {
        this.classPathResolvingEnabled = classPathResolvingEnabled;
        return this;
    }

    public boolean isFileCachingEnabled() {
        return this.fileCachingEnabled;
    }

    public FileSystemOptions setFileCachingEnabled(boolean fileCachingEnabled) {
        this.fileCachingEnabled = fileCachingEnabled;
        return this;
    }

    public String getFileCacheDir() {
        return this.fileCacheDir;
    }

    public FileSystemOptions setFileCacheDir(String fileCacheDir) {
        this.fileCacheDir = fileCacheDir;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemOptions that = (FileSystemOptions)o;
        if (this.classPathResolvingEnabled != that.isClassPathResolvingEnabled()) {
            return false;
        }
        return this.fileCachingEnabled == that.isFileCachingEnabled();
    }

    public int hashCode() {
        int result = this.classPathResolvingEnabled ? 1 : 0;
        return 31 * (result += this.fileCachingEnabled ? 1 : 0);
    }

    public String toString() {
        return "FileSystemOptions{classPathResolvingEnabled=" + this.classPathResolvingEnabled + ", fileCachingEnabled=" + this.fileCachingEnabled + ", fileCacheDir=" + this.fileCacheDir + '}';
    }
}

