/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.security.SFile;

public class FileUtils {
    private static AtomicInteger counter;

    public static void resetCounter() {
        counter = new AtomicInteger(0);
    }

    public static File createTempFileLegacy(String prefix, String suffix) throws IOException {
        File f;
        if (!suffix.startsWith(".")) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(prefix);
        if (counter == null) {
            f = File.createTempFile(prefix, suffix);
        } else {
            String name = prefix + counter.addAndGet(1) + suffix;
            f = new File(name);
        }
        Log.info("Creating temporary file: " + f);
        f.deleteOnExit();
        return f;
    }

    public static SFile createTempFile(String prefix, String suffix) throws IOException {
        SFile f;
        if (!suffix.startsWith(".")) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(prefix);
        if (counter == null) {
            f = SFile.createTempFile(prefix, suffix);
        } else {
            String name = prefix + counter.addAndGet(1) + suffix;
            f = new SFile(name);
        }
        Log.info("Creating temporary file: " + f);
        f.deleteOnExit();
        return f;
    }

    public static void copyInternal(InputStream fis, OutputStream fos, boolean close) throws IOException {
        int len;
        byte[] buf = new byte[10240];
        while ((len = fis.read(buf)) > 0) {
            fos.write(buf, 0, len);
        }
        if (close) {
            fos.close();
            fis.close();
        }
    }

    public static void copyToFile(SFile src, SFile dest) throws IOException {
        InputStream fis;
        if (dest.isDirectory()) {
            dest = dest.file(src.getName());
        }
        if ((fis = src.openFile()) == null) {
            throw new FileNotFoundException();
        }
        BufferedOutputStream fos = dest.createBufferedOutputStream();
        FileUtils.copyInternal(fis, fos, true);
    }

    public static void copyToStream(SFile src, OutputStream os) throws IOException {
        InputStream fis = src.openFile();
        if (fis == null) {
            throw new FileNotFoundException();
        }
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos, true);
    }

    public static void copyToStream(File src, OutputStream os) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos, true);
    }

    public static void copyToStream(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(is);
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos, true);
    }

    public static void copyToFile(byte[] src, SFile dest) throws IOException {
        try (BufferedOutputStream fos = dest.createBufferedOutputStream();){
            ((OutputStream)fos).write(src);
        }
    }

    public static String readSvg(SFile svgFile) throws IOException {
        BufferedReader br = svgFile.openBufferedReader();
        if (br == null) {
            return null;
        }
        return FileUtils.readSvg(br, false, true);
    }

    public static String readSvg(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return FileUtils.readSvg(br, false, false);
    }

    public static String readText(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return FileUtils.readSvg(br, true, true);
    }

    public static String readFile(SFile svgFile) throws IOException {
        BufferedReader br = svgFile.openBufferedReader();
        if (br == null) {
            return null;
        }
        return FileUtils.readSvg(br, true, true);
    }

    private static String readSvg(BufferedReader br, boolean withNewline, boolean withClose) throws IOException {
        String s2;
        StringBuilder sb = new StringBuilder();
        while ((s2 = br.readLine()) != null) {
            sb.append(s2);
            if (!withNewline) continue;
            sb.append("\n");
        }
        if (withClose) {
            br.close();
        }
        return sb.toString();
    }
}

