/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.command;

import java.util.regex.Matcher;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandActivity3
extends SingleLineCommand2<ActivityDiagram3> {
    public static final String endingGroup() {
        return "(;|" + Matcher.quoteReplacement("\\\\") + "|(?<![/|<>}\\]])[/<}]|(?<![/|}\\]])\\]|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<[&$]\\w{1,999})(?<!\\>)\\>|(?<!\\|.{1,999})\\|)";
    }

    public static void main(String[] args) {
        System.err.println(Matcher.quoteReplacement("\\\\"));
        System.err.println(Matcher.quoteReplacement("\\\\").equals("\\\\\\\\"));
    }

    public CommandActivity3() {
        super(CommandActivity3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandActivity3.class.getName(), RegexLeaf.start(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), CommandActivity3.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), new RegexLeaf("LABEL", "(.*)"), new RegexLeaf("STYLE", CommandActivity3.endingGroup()), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Url url;
        if (arg.get("URL", 0) == null) {
            url = null;
        } else {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            url = urlBuilder.getUrl(arg.get("URL", 0));
        }
        Colors colors = CommandActivity3.color().getColor(diagram.getSkinParam().getThemeStyle(), arg, diagram.getSkinParam().getIHtmlColorSet());
        String stereo = arg.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereo != null) {
            stereotype = Stereotype.build(stereo);
            colors = colors.applyStereotype(stereotype, diagram.getSkinParam(), ColorParam.activityBackground);
        }
        BoxStyle style = BoxStyle.fromChar(arg.get("STYLE", 0).charAt(0));
        Display display = Display.getWithNewlines2(arg.get("LABEL", 0));
        return diagram.addActivity(display, style, url, colors, stereotype);
    }
}

