/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class GtileTopDown
extends AbstractGtile {
    protected final Gtile tile1;
    protected final Gtile tile2;
    private final Dimension2D dim1;
    private final Dimension2D dim2;
    private final UTranslate pos1;
    private final UTranslate pos2;

    public String toString() {
        return "GtileTopDown(" + this.tile1 + " && " + this.tile2 + ")";
    }

    public GtileTopDown(Gtile tile1, Gtile tile2) {
        super(tile1.getStringBounder(), tile1.skinParam());
        this.tile1 = tile1;
        this.tile2 = tile2;
        this.dim1 = tile1.calculateDimension(this.stringBounder);
        this.dim2 = tile2.calculateDimension(this.stringBounder);
        UTranslate vector1 = tile1.getCoord("SOUTH_BORDER");
        UTranslate vector2 = tile2.getCoord("NORTH_BORDER");
        double maxDx = Math.max(vector1.getDx(), vector2.getDx());
        this.pos1 = UTranslate.dx(maxDx - vector1.getDx());
        this.pos2 = new UTranslate(maxDx - vector2.getDx(), this.dim1.getHeight());
    }

    protected UTranslate supplementaryMove() {
        return new UTranslate();
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        if (name.equals("NORTH_HOOK")) {
            return this.getPos1().compose(this.tile1.getCoord(name));
        }
        if (name.equals("SOUTH_HOOK")) {
            return this.getPos2().compose(this.tile2.getCoord(name));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Swimlane getSwimlane(String name) {
        if (name.equals("NORTH_HOOK")) {
            return this.tile1.getSwimlane(name);
        }
        if (name.equals("SOUTH_HOOK")) {
            return this.tile2.getSwimlane(name);
        }
        throw new UnsupportedOperationException();
    }

    protected UTranslate getPos1() {
        return this.pos1;
    }

    protected UTranslate getPos2() {
        return this.pos2.compose(this.supplementaryMove());
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        ug.apply(this.getPos1()).draw(this.tile1);
        ug.apply(this.getPos2()).draw(this.tile2);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D corner1 = this.getPos1().getTranslated(this.dim1);
        Dimension2D corner2 = this.getPos2().getTranslated(this.dim2);
        return MathUtils.max(corner1, corner2);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        result.addAll(this.tile1.getSwimlanes());
        result.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }
}

