/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.braille;

import znaishaded.net.sourceforge.plantuml.braille.BrailleGrid;

public class BrailleChar {
    private final int id;

    private BrailleChar(int id) {
        this.id = id;
    }

    public void draw(BrailleGrid grid, double xv, double yv) {
        int x = grid.toInt(xv);
        int y = grid.toInt(yv);
        this.drawOneSpot(grid, x + 0, y + 0, 1);
        this.drawOneSpot(grid, x + 0, y + 1, 2);
        this.drawOneSpot(grid, x + 0, y + 2, 4);
        this.drawOneSpot(grid, x + 1, y + 0, 8);
        this.drawOneSpot(grid, x + 1, y + 1, 16);
        this.drawOneSpot(grid, x + 1, y + 2, 32);
    }

    private void drawOneSpot(BrailleGrid grid, int x, int y, int check) {
        if ((this.id & check) != 0) {
            grid.setState(x, y, true);
        }
    }

    public static BrailleChar fromChar(char c) {
        if (c == 'a' || c == 'A' || c == '1') {
            return new BrailleChar(1);
        }
        if (c == 'b' || c == 'B' || c == '2') {
            return new BrailleChar(3);
        }
        if (c == 'c' || c == 'C' || c == '3') {
            return new BrailleChar(9);
        }
        if (c == 'd' || c == 'D' || c == '4') {
            return new BrailleChar(25);
        }
        if (c == 'e' || c == 'E' || c == '5') {
            return new BrailleChar(17);
        }
        if (c == 'f' || c == 'F' || c == '6') {
            return new BrailleChar(11);
        }
        if (c == 'g' || c == 'G' || c == '7') {
            return new BrailleChar(27);
        }
        if (c == 'h' || c == 'H' || c == '8') {
            return new BrailleChar(19);
        }
        if (c == 'i' || c == 'I' || c == '9') {
            return new BrailleChar(10);
        }
        if (c == 'j' || c == 'J' || c == '0') {
            return new BrailleChar(26);
        }
        if (c == 'k' || c == 'K') {
            return new BrailleChar(5);
        }
        if (c == 'l' || c == 'L') {
            return new BrailleChar(7);
        }
        if (c == 'm' || c == 'M') {
            return new BrailleChar(13);
        }
        if (c == 'n' || c == 'N') {
            return new BrailleChar(29);
        }
        if (c == 'o' || c == 'O') {
            return new BrailleChar(21);
        }
        if (c == 'p' || c == 'P') {
            return new BrailleChar(15);
        }
        if (c == 'q' || c == 'Q') {
            return new BrailleChar(31);
        }
        if (c == 'r' || c == 'R') {
            return new BrailleChar(23);
        }
        if (c == 's' || c == 'S') {
            return new BrailleChar(14);
        }
        if (c == 't' || c == 'T') {
            return new BrailleChar(30);
        }
        if (c == 'u' || c == 'U') {
            return new BrailleChar(37);
        }
        if (c == 'v' || c == 'V') {
            return new BrailleChar(39);
        }
        if (c == 'w' || c == 'W') {
            return new BrailleChar(58);
        }
        if (c == 'x' || c == 'X') {
            return new BrailleChar(45);
        }
        if (c == 'y' || c == 'Y') {
            return new BrailleChar(61);
        }
        if (c == 'z' || c == 'Z') {
            return new BrailleChar(53);
        }
        if (c == ' ') {
            return new BrailleChar(0);
        }
        if (c == '\'') {
            return new BrailleChar(2);
        }
        if (c == ';') {
            return new BrailleChar(6);
        }
        if (c == ':') {
            return new BrailleChar(18);
        }
        if (c == '!') {
            return new BrailleChar(22);
        }
        if (c == '(' || c == ')') {
            return new BrailleChar(54);
        }
        if (c == '?' || c == '.' || c == '\"') {
            return new BrailleChar(38);
        }
        if (c == ',') {
            return new BrailleChar(4);
        }
        if (c == '-') {
            return new BrailleChar(36);
        }
        return new BrailleChar(63);
    }
}

