/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.legacy.CreoleParser;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Bodier;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhanced1;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyFactory;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.skin.VisibilityModifier;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;

public class BodierLikeClassOrObject
implements Bodier {
    private final List<CharSequence> rawBody = new ArrayList<CharSequence>();
    private final Set<VisibilityModifier> hides;
    private LeafType type;
    private List<Member> methodsToDisplay;
    private List<Member> fieldsToDisplay;
    private ILeaf leaf;

    @Override
    public void muteClassToObject() {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.type = LeafType.OBJECT;
    }

    BodierLikeClassOrObject(LeafType type, Set<VisibilityModifier> hides) {
        if (type == LeafType.MAP) {
            throw new IllegalArgumentException();
        }
        this.type = Objects.requireNonNull(type);
        assert (type.isLikeClass() || type == LeafType.OBJECT);
        this.hides = hides;
    }

    @Override
    public void setLeaf(ILeaf leaf) {
        this.leaf = Objects.requireNonNull(leaf);
    }

    @Override
    public boolean addFieldOrMethod(String s2) {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.rawBody.add(s2);
        return true;
    }

    private boolean isBodyEnhanced() {
        for (CharSequence s2 : this.rawBody) {
            if (!BodyEnhanced1.isBlockSeparator(s2) && !CreoleParser.isTableLine(s2.toString()) && !Parser.isTreeStart(s2.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isMethod(CharSequence s2) {
        String purged = s2.toString().replaceAll(UrlBuilder.getRegexp(), "");
        if (purged.contains("{method}")) {
            return true;
        }
        if (purged.contains("{field}")) {
            return false;
        }
        return purged.contains("(") || purged.contains(")");
    }

    @Override
    public Display getMethodsToDisplay() {
        if (this.methodsToDisplay == null) {
            this.methodsToDisplay = new ArrayList<Member>();
            for (int i = 0; i < this.rawBody.size(); ++i) {
                CharSequence s2 = this.rawBody.get(i);
                if (!this.isMethod(i, this.rawBody) || s2.length() == 0 && this.methodsToDisplay.size() == 0) continue;
                Member m3 = Member.method(s2);
                if (this.hides != null && this.hides.contains((Object)m3.getVisibilityModifier())) continue;
                this.methodsToDisplay.add(m3);
            }
            this.removeFinalEmptyMembers(this.methodsToDisplay);
        }
        return Display.create(this.methodsToDisplay);
    }

    private boolean isMethod(int i, List<CharSequence> rawBody) {
        if (i > 0 && i < rawBody.size() - 1 && rawBody.get(i).length() == 0 && this.isMethod(rawBody.get(i - 1)) && this.isMethod(rawBody.get(i + 1))) {
            return true;
        }
        return this.isMethod(rawBody.get(i));
    }

    @Override
    public Display getFieldsToDisplay() {
        if (this.fieldsToDisplay == null) {
            this.fieldsToDisplay = new ArrayList<Member>();
            for (CharSequence s2 : this.rawBody) {
                if (this.type != LeafType.OBJECT && this.isMethod(s2) || s2.length() == 0 && this.fieldsToDisplay.size() == 0) continue;
                Member m3 = Member.field(s2);
                if (this.hides != null && this.hides.contains((Object)m3.getVisibilityModifier())) continue;
                this.fieldsToDisplay.add(m3);
            }
            this.removeFinalEmptyMembers(this.fieldsToDisplay);
        }
        return Display.create(this.fieldsToDisplay);
    }

    private void removeFinalEmptyMembers(List<Member> result) {
        while (result.size() > 0 && StringUtils.trin(result.get(result.size() - 1).getDisplay(false)).length() == 0) {
            result.remove(result.size() - 1);
        }
    }

    @Override
    public boolean hasUrl() {
        Member m3;
        for (CharSequence cs : this.getFieldsToDisplay()) {
            if (!(cs instanceof Member) || !(m3 = (Member)cs).hasUrl()) continue;
            return true;
        }
        for (CharSequence cs : this.getMethodsToDisplay()) {
            if (!(cs instanceof Member) || !(m3 = (Member)cs).hasUrl()) continue;
            return true;
        }
        return false;
    }

    private List<CharSequence> rawBodyWithoutHidden() {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence s2 : this.rawBody) {
            Member m3 = this.isMethod(s2) ? Member.method(s2) : Member.field(s2);
            if (this.hides.contains((Object)m3.getVisibilityModifier())) continue;
            result.add(m3);
        }
        return result;
    }

    @Override
    public TextBlock getBody(FontParam fontParam, ISkinParam skinParam, boolean showMethods, boolean showFields, Stereotype stereotype, Style style, FontConfiguration fontConfiguration) {
        if (this.type.isLikeClass() && this.isBodyEnhanced()) {
            if (showMethods || showFields) {
                return BodyFactory.create1(skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.rawBodyWithoutHidden(), skinParam, stereotype, this.leaf, style);
            }
            return null;
        }
        if (this.leaf == null) {
            throw new IllegalStateException();
        }
        if (this.type == LeafType.OBJECT) {
            if (!showFields) {
                return new TextBlockLineBefore(style.value(PName.LineThickness).asDouble(), TextBlockUtils.empty(0.0, 0.0));
            }
            return BodyFactory.create1(skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.rawBodyWithoutHidden(), skinParam, stereotype, this.leaf, style);
        }
        assert (this.type.isLikeClass());
        MethodsOrFieldsArea fields = new MethodsOrFieldsArea(this.getFieldsToDisplay(), skinParam, this.leaf, style);
        MethodsOrFieldsArea methods = new MethodsOrFieldsArea(this.getMethodsToDisplay(), skinParam, this.leaf, style);
        if (showFields && !showMethods) {
            return fields.asBlockMemberImpl();
        }
        if (showMethods && !showFields) {
            return methods.asBlockMemberImpl();
        }
        if (!showFields && !showMethods) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        TextBlock bb1 = fields.asBlockMemberImpl();
        TextBlock bb2 = methods.asBlockMemberImpl();
        return TextBlockUtils.mergeTB(bb1, bb2, HorizontalAlignment.LEFT);
    }

    @Override
    public List<CharSequence> getRawBody() {
        return Collections.unmodifiableList(this.rawBody);
    }
}

