/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.BackSlash;
import znaishaded.net.sourceforge.plantuml.EmbeddedDiagram;
import znaishaded.net.sourceforge.plantuml.Guillemet;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.LineLocationImpl;
import znaishaded.net.sourceforge.plantuml.SpriteContainer;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.creole.legacy.CreoleParser;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.CircledCharacter;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockSprited;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.sequencediagram.MessageNumber;
import znaishaded.net.sourceforge.plantuml.skin.VisibilityModifier;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.Value;
import znaishaded.net.sourceforge.plantuml.style.ValueNull;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class Display
implements Iterable<CharSequence> {
    private final List<CharSequence> displayData;
    private final HorizontalAlignment naturalHorizontalAlignment;
    private final boolean isNull;
    private final CreoleMode defaultCreoleMode;
    private final boolean showStereotype;
    public static final Display NULL = new Display(true, null, null, true, CreoleMode.FULL);
    public static final Pattern2 patternStereotype = MyPattern.cmpile("^(.*?)(?:\\<\\<\\s*(.*)\\s*\\>\\>)\\s*$");

    public boolean showStereotype() {
        return this.showStereotype;
    }

    public Display withoutStereotypeIfNeeded(Style usedStyle) {
        if (this == NULL) {
            return NULL;
        }
        Value showStereotype = usedStyle.value(PName.ShowStereotype);
        if (showStereotype instanceof ValueNull || showStereotype.asBoolean()) {
            return this;
        }
        return new Display(false, this, this.defaultCreoleMode);
    }

    public Stereotype getStereotypeIfAny() {
        for (CharSequence cs : this.displayData) {
            if (!(cs instanceof Stereotype)) continue;
            return (Stereotype)cs;
        }
        return null;
    }

    public Display replaceBackslashT() {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        for (int i = 0; i < result.displayData.size(); ++i) {
            CharSequence s2 = this.displayData.get(i);
            if (!s2.toString().contains("\\t")) continue;
            result.displayData.set(i, s2.toString().replace("\\t", "\t"));
        }
        return result;
    }

    public Display replace(String src, String dest) {
        ArrayList<CharSequence> newDisplay = new ArrayList<CharSequence>();
        for (CharSequence cs : this.displayData) {
            if (cs.toString().contains(src)) {
                cs = cs.toString().replace(src, dest);
            }
            newDisplay.add(cs);
        }
        return new Display(this.showStereotype, newDisplay, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public boolean isWhite() {
        return this.displayData == null || this.displayData.size() == 0 || this.displayData.size() == 1 && this.displayData.get(0).toString().matches("\\s*");
    }

    public static Display empty() {
        return new Display(true, null, false, CreoleMode.FULL);
    }

    public static Display create(CharSequence ... s2) {
        return Display.create(Arrays.asList(s2));
    }

    public static Display createFoo(List<StringLocated> data) throws NoSuchColorException {
        ArrayList<String> tmp = new ArrayList<String>();
        for (StringLocated s2 : data) {
            tmp.add(s2.getString());
        }
        Display result = Display.create(tmp);
        CreoleParser.checkColor(result);
        return result;
    }

    public static Display create(Collection<? extends CharSequence> other) {
        return new Display(true, other, null, false, CreoleMode.FULL);
    }

    public static Display getWithNewlines(Code s2) {
        return Display.getWithNewlines(s2.getName());
    }

    public static Display getWithNewlines2(String s2) throws NoSuchColorException {
        Display result = Display.getWithNewlines(s2);
        CreoleParser.checkColor(result);
        return result;
    }

    public static Display getWithNewlines(String s2) {
        if (s2 == null) {
            return NULL;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        HorizontalAlignment naturalHorizontalAlignment = null;
        boolean rawMode = false;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            String sub = s2.substring(i);
            if (sub.startsWith("<math>") || sub.startsWith("<latex>") || sub.startsWith("[[")) {
                rawMode = true;
            } else if (sub.startsWith("</math>") || sub.startsWith("</latex>") || sub.startsWith("]]")) {
                rawMode = false;
            }
            if (!rawMode && c == '\\' && i < s2.length() - 1) {
                char c2 = s2.charAt(i + 1);
                ++i;
                if (c2 == 'n' || c2 == 'r' || c2 == 'l') {
                    if (c2 == 'r') {
                        naturalHorizontalAlignment = HorizontalAlignment.RIGHT;
                    } else if (c2 == 'l') {
                        naturalHorizontalAlignment = HorizontalAlignment.LEFT;
                    }
                    result.add(current.toString());
                    current.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    current.append('\t');
                    continue;
                }
                if (c2 == '\\') {
                    current.append(c2);
                    continue;
                }
                current.append(c);
                current.append(c2);
                continue;
            }
            if (c == BackSlash.hiddenNewLine()) {
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        result.add(current.toString());
        return new Display(true, result, naturalHorizontalAlignment, false, CreoleMode.FULL);
    }

    private Display(boolean showStereotype, Display other, CreoleMode mode) {
        this(showStereotype, other.naturalHorizontalAlignment, other.isNull, mode);
        this.displayData.addAll(other.displayData);
    }

    private Display(boolean showStereotype, HorizontalAlignment naturalHorizontalAlignment, boolean isNull, CreoleMode defaultCreoleMode) {
        this.showStereotype = showStereotype;
        this.defaultCreoleMode = defaultCreoleMode;
        this.isNull = isNull;
        this.displayData = isNull ? null : new ArrayList();
        this.naturalHorizontalAlignment = isNull ? null : naturalHorizontalAlignment;
    }

    private Display(boolean showStereotype, Collection<? extends CharSequence> other, HorizontalAlignment naturalHorizontalAlignment, boolean isNull, CreoleMode defaultCreoleMode) {
        this(showStereotype, naturalHorizontalAlignment, isNull, defaultCreoleMode);
        if (!isNull) {
            this.displayData.addAll(Display.manageEmbeddedDiagrams(other));
        }
    }

    private static List<CharSequence> manageEmbeddedDiagrams(Collection<? extends CharSequence> strings) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        Iterator<? extends CharSequence> it = strings.iterator();
        while (it.hasNext()) {
            CharSequence s2 = it.next();
            String type = EmbeddedDiagram.getEmbeddedType(s2);
            if (type != null) {
                CharSequence s22;
                ArrayList<CharSequence> other = new ArrayList<CharSequence>();
                other.add("@start" + type);
                while (it.hasNext() && ((s22 = it.next()) == null || !StringUtils.trin(s22.toString()).equals("}}"))) {
                    other.add(s22);
                }
                other.add("@end" + type);
                s2 = new EmbeddedDiagram(Display.create(other));
            }
            result.add(s2);
        }
        return result;
    }

    public Display manageGuillemet() {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        boolean first = true;
        for (CharSequence line : this.displayData) {
            if (line instanceof EmbeddedDiagram) {
                result.add(line);
            } else {
                String lineString = line.toString();
                if (first && VisibilityModifier.isVisibilityCharacter(line)) {
                    lineString = lineString.substring(1).trim();
                }
                String withGuillement = Guillemet.GUILLEMET.manageGuillemet(lineString);
                result.add(withGuillement);
            }
            first = false;
        }
        return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display withPage(int page, int lastpage) {
        if (this.displayData == null) {
            return this;
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence line : this.displayData) {
            line = line.toString().replace("%page%", "" + page);
            line = line.toString().replace("%lastpage%", "" + lastpage);
            result.add(line);
        }
        return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display removeEndingStereotype() {
        Matcher2 m3 = patternStereotype.matcher(this.displayData.get(this.displayData.size() - 1));
        if (m3.matches()) {
            ArrayList<CharSequence> result = new ArrayList<CharSequence>(this.displayData);
            result.set(result.size() - 1, m3.group(1));
            return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
        }
        return this;
    }

    public String getEndingStereotype() {
        Matcher2 m3 = patternStereotype.matcher(this.displayData.get(this.displayData.size() - 1));
        if (m3.matches()) {
            return m3.group(2);
        }
        return null;
    }

    public Display underlined() {
        ArrayList<String> result = new ArrayList<String>();
        for (CharSequence line : this.displayData) {
            result.add("<u>" + line);
        }
        return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display underlinedName() {
        Pattern p = Pattern.compile("^([^:]+?)(\\s*:.+)$");
        ArrayList<String> result = new ArrayList<String>();
        for (CharSequence line : this.displayData) {
            if (result.size() == 0) {
                Matcher m3 = p.matcher(line);
                if (m3.matches()) {
                    result.add("<u>" + m3.group(1) + "</u>" + m3.group(2));
                    continue;
                }
                result.add("<u>" + line);
                continue;
            }
            result.add("<u>" + line);
        }
        return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display withCreoleMode(CreoleMode mode) {
        if (this.isNull) {
            throw new IllegalArgumentException();
        }
        return new Display(this.showStereotype, this, mode);
    }

    public String toString() {
        if (this.isNull) {
            return "NULL";
        }
        return this.displayData.toString();
    }

    public int hashCode() {
        return this.displayData.hashCode();
    }

    public boolean equals(Object other) {
        return this.displayData.equals(((Display)other).displayData);
    }

    public Display addAll(Display other) {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        result.displayData.addAll(other.displayData);
        return result;
    }

    public Display addFirst(CharSequence s2) {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        result.displayData.add(0, s2);
        return result;
    }

    public Display add(CharSequence s2) {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        result.displayData.add(s2);
        return result;
    }

    public Display addGeneric(CharSequence s2) {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        int size = this.displayData.size();
        if (size == 0) {
            result.displayData.add("<" + s2 + ">");
        } else {
            result.displayData.set(size - 1, this.displayData.get(size - 1) + "<" + s2 + ">");
        }
        return result;
    }

    public int size() {
        if (this.isNull) {
            return 0;
        }
        return this.displayData.size();
    }

    public CharSequence get(int i) {
        return this.displayData.get(i);
    }

    @Override
    public ListIterator<CharSequence> iterator() {
        return Collections.unmodifiableList(this.displayData).listIterator();
    }

    public Display subList(int i, int size) {
        return new Display(this.showStereotype, this.displayData.subList(i, size), this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public List<? extends CharSequence> asList() {
        return Collections.unmodifiableList(this.displayData);
    }

    public List<StringLocated> as2() {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        LineLocationImpl location = new LineLocationImpl("inner", null);
        for (CharSequence cs : this.displayData) {
            location = location.oneLineRead();
            result.add(new StringLocated(cs.toString(), location));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean hasUrl() {
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlMode.ANYWHERE);
        for (CharSequence s2 : this) {
            if (urlBuilder.getUrl(s2.toString()) == null) continue;
            return true;
        }
        return false;
    }

    public HorizontalAlignment getNaturalHorizontalAlignment() {
        return this.naturalHorizontalAlignment;
    }

    public List<Display> splitMultiline(Pattern2 separator) {
        ArrayList<Display> result = new ArrayList<Display>();
        Display pending = new Display(this.showStereotype, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
        result.add(pending);
        for (CharSequence line : this.displayData) {
            Matcher2 m3 = separator.matcher(line);
            if (m3.find()) {
                CharSequence s1 = line.subSequence(0, m3.start());
                pending.displayData.add(s1);
                CharSequence s2 = line.subSequence(m3.end(), line.length());
                pending = new Display(this.showStereotype, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
                result.add(pending);
                pending.displayData.add(s2);
                continue;
            }
            pending.displayData.add(line);
        }
        return Collections.unmodifiableList(result);
    }

    public static boolean isNull(Display display) {
        return display == null || display.isNull;
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer) {
        return this.create7(fontConfiguration, horizontalAlignment, spriteContainer, CreoleMode.FULL);
    }

    public TextBlock createWithNiceCreoleMode(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer) {
        return this.create7(fontConfiguration, horizontalAlignment, spriteContainer, this.defaultCreoleMode);
    }

    public TextBlock create7(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, CreoleMode creoleMode) {
        return this.create0(fontConfiguration, horizontalAlignment, spriteContainer, LineBreakStrategy.NONE, creoleMode, null, null);
    }

    public TextBlock create8(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, CreoleMode modeSimpleLine, LineBreakStrategy maxMessageSize) {
        return this.create0(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, modeSimpleLine, null, null);
    }

    public TextBlock create9(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize) {
        return this.create0(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, this.defaultCreoleMode, null, null);
    }

    public TextBlock create0(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode creoleMode, UFont fontForStereotype, HColor htmlColorForStereotype) {
        return this.create0(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, creoleMode, fontForStereotype, htmlColorForStereotype, 0.0, 0.0);
    }

    public TextBlock create0(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode creoleMode, UFont fontForStereotype, HColor htmlColorForStereotype, double marginX1, double marginX2) {
        Objects.requireNonNull(maxMessageSize);
        if (this.getNaturalHorizontalAlignment() != null) {
            horizontalAlignment = this.getNaturalHorizontalAlignment();
        }
        FontConfiguration stereotypeConfiguration = fontConfiguration.forceFont(fontForStereotype, htmlColorForStereotype);
        if (this.size() > 0) {
            if (this.get(0) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, spriteContainer, 0, fontForStereotype, htmlColorForStereotype, maxMessageSize, creoleMode, marginX1, marginX2);
            }
            if (this.get(this.size() - 1) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, spriteContainer, this.size() - 1, fontForStereotype, htmlColorForStereotype, maxMessageSize, creoleMode, marginX1, marginX2);
            }
            if (this.get(0) instanceof MessageNumber) {
                return this.createMessageNumber(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, stereotypeConfiguration, marginX1, marginX2);
            }
        }
        return this.getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, creoleMode, stereotypeConfiguration, marginX1, marginX2);
    }

    private TextBlock createStereotype(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, int position, UFont fontForStereotype, HColor htmlColorForStereotype, LineBreakStrategy maxMessageSize, CreoleMode creoleMode, double marginX1, double marginX2) {
        Stereotype stereotype = (Stereotype)this.get(position);
        TextBlock circledCharacter = null;
        circledCharacter = stereotype.isSpotted() ? new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor()) : stereotype.getSprite(spriteContainer);
        FontConfiguration stereotypeConfiguration = fontConfiguration.forceFont(fontForStereotype, htmlColorForStereotype);
        TextBlock result = this.getCreole(fontConfiguration, horizontalAlignment, (ISkinSimple)spriteContainer, maxMessageSize, creoleMode, stereotypeConfiguration, marginX1, marginX2);
        if (circledCharacter != null) {
            return new TextBlockSprited(circledCharacter, result);
        }
        return result;
    }

    private TextBlock getCreole(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode creoleMode, FontConfiguration stereotypeConfiguration, double marginX1, double marginX2) {
        Sheet sheet = Parser.build(fontConfiguration, horizontalAlignment, spriteContainer, creoleMode, stereotypeConfiguration).createSheet(this);
        double padding = spriteContainer == null ? 0.0 : spriteContainer.getPadding();
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, maxMessageSize, padding, marginX1, marginX2);
        return new SheetBlock2(sheetBlock1, sheetBlock1, new UStroke(1.5));
    }

    private TextBlock createMessageNumber(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, FontConfiguration stereotypeConfiguration, double marginX1, double marginX2) {
        TextBlock tb1 = this.subList(0, 1).getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL, stereotypeConfiguration, marginX1, marginX2);
        tb1 = TextBlockUtils.withMargin(tb1, 0.0, 4.0, 0.0, 0.0);
        TextBlock tb2 = this.subList(1, this.size()).getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL, stereotypeConfiguration, marginX1, marginX2);
        return TextBlockUtils.mergeLR(tb1, tb2, VerticalAlignment.CENTER);
    }

    public boolean hasSeveralGuideLines() {
        return Display.hasSeveralGuideLines(this.displayData);
    }

    public static boolean hasSeveralGuideLines(String s2) {
        List<String> splitted = Arrays.asList(s2.split("\\\\n"));
        return Display.hasSeveralGuideLines(splitted);
    }

    private static boolean hasSeveralGuideLines(Collection<? extends CharSequence> all) {
        if (all.size() <= 1) {
            return false;
        }
        for (CharSequence charSequence : all) {
            String s2 = charSequence.toString();
            if (s2.startsWith("< ")) {
                return true;
            }
            if (s2.startsWith("> ")) {
                return true;
            }
            if (s2.endsWith(" <")) {
                return true;
            }
            if (!s2.endsWith(" >")) continue;
            return true;
        }
        return false;
    }
}

