/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.emoji;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.emoji.UGraphicWithScale;
import znaishaded.net.sourceforge.plantuml.emoji.data.Dummy;
import znaishaded.net.sourceforge.plantuml.openiconic.SvgPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorChangerMonochrome;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSimple;

public class Emoji {
    private static final Map<String, Emoji> ALL = new HashMap<String, Emoji>();
    private final List<String> data = new ArrayList<String>();
    private int minGray = 999;
    private int maxGray = -1;
    private final String unicode;
    private final String shortcut;

    public static Map<String, Emoji> getAll() {
        return Collections.unmodifiableMap(new TreeMap<String, Emoji>(ALL));
    }

    private Emoji(String unicode) {
        int x = unicode.indexOf(59);
        if (x == -1) {
            this.shortcut = null;
        } else {
            this.shortcut = unicode.substring(x + 1);
            ALL.put(this.shortcut, this);
            unicode = unicode.substring(0, x);
        }
        this.unicode = unicode;
        ALL.put(unicode, this);
    }

    public static String pattern() {
        StringBuilder sb = new StringBuilder("\\<(#\\w+)?:(");
        for (String s2 : ALL.keySet()) {
            if (!sb.toString().endsWith("(")) {
                sb.append("|");
            }
            sb.append(s2);
        }
        sb.append("):\\>");
        return sb.toString();
    }

    public static Emoji retrieve(String name) {
        return ALL.get(name.toLowerCase());
    }

    private String extractData(String name, String s2) {
        Pattern p = Pattern.compile(name + "=\"([^\"]+)\"");
        Matcher m3 = p.matcher(s2);
        if (m3.find()) {
            return m3.group(1);
        }
        return null;
    }

    private synchronized void loadIfNeed() throws IOException {
        if (this.data.size() > 0) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Dummy.class.getResourceAsStream(this.unicode + ".svg")));){
            String singleLine = br.readLine();
            Pattern p = Pattern.compile("\\<[^<>]+\\>");
            Matcher m3 = p.matcher(singleLine);
            while (m3.find()) {
                String s2 = m3.group(0);
                if (s2.contains("<path") || s2.contains("<g ") || s2.contains("<g>") || s2.contains("</g>") || s2.contains("<circle ") || s2.contains("<ellipse ")) {
                    this.data.add(s2);
                    continue;
                }
                System.err.println("???=" + s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawU(UGraphic ug, double scale, HColor colorForMonochrome) {
        try {
            this.loadIfNeed();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        UGraphicWithScale ugs = new UGraphicWithScale(ug, scale);
        Emoji emoji = this;
        synchronized (emoji) {
            if (colorForMonochrome != null && this.maxGray == -1) {
                this.computeMinMaxGray();
            }
        }
        ArrayList<UGraphicWithScale> stack = new ArrayList<UGraphicWithScale>();
        for (String s2 : this.data) {
            if (s2.contains("<path ")) {
                this.drawPath(ugs, s2, colorForMonochrome);
                continue;
            }
            if (s2.contains("</g>")) {
                ugs = (UGraphicWithScale)stack.remove(0);
                continue;
            }
            if (s2.contains("<g>")) {
                stack.add(0, ugs);
                continue;
            }
            if (s2.contains("<g ")) {
                stack.add(0, ugs);
                ugs = this.applyFill(ugs, s2, colorForMonochrome);
                ugs = this.applyTransform(ugs, s2);
                continue;
            }
            if (s2.contains("<circle ")) {
                this.drawCircle(ugs, s2, colorForMonochrome);
                continue;
            }
            if (s2.contains("<ellipse ")) {
                this.drawEllipse(ugs, s2, colorForMonochrome);
                continue;
            }
            System.err.println("**?=" + s2);
        }
    }

    private void computeMinMaxGray() {
        for (String s2 : this.data) {
            HColor color;
            if (!s2.contains("<path ") && !s2.contains("<g ") && !s2.contains("<circle ") && !s2.contains("<ellipse ") || (color = this.justExtractColor(s2)) == null) continue;
            int gray = this.getGray(color);
            this.minGray = Math.min(this.minGray, gray);
            this.maxGray = Math.max(this.maxGray, gray);
        }
    }

    private int getGray(HColor col) {
        Color tmp = new ColorChangerMonochrome().getChangedColor(col);
        return tmp.getGreen();
    }

    private UGraphicWithScale applyFill(UGraphicWithScale ugs, String s2, HColor colorForMonochrome) {
        String fillString = this.extractData("fill", s2);
        if (fillString == null) {
            return ugs;
        }
        if (fillString.equals("none")) {
            String strokeString = this.extractData("stroke", s2);
            if (strokeString == null) {
                return ugs;
            }
            ugs = ugs.apply(new HColorNone().bg());
            HColor stroke = this.getTrueColor(strokeString, colorForMonochrome);
            ugs = ugs.apply(stroke);
            String strokeWidth = this.extractData("stroke-width", s2);
            if (strokeWidth != null) {
                ugs = ugs.apply(new UStroke(Double.parseDouble(strokeWidth)));
            }
        } else {
            HColor fill = this.getTrueColor(fillString, colorForMonochrome);
            ugs = ugs.apply(fill).apply(fill.bg());
        }
        return ugs;
    }

    private HColor justExtractColor(String s2) {
        String fillString = this.extractData("fill", s2);
        if (fillString == null) {
            return null;
        }
        if (fillString.equals("none")) {
            String strokeString = this.extractData("stroke", s2);
            if (strokeString == null) {
                return null;
            }
            HColor stroke = this.getTrueColor(strokeString, null);
            return stroke;
        }
        HColor fill = this.getTrueColor(fillString, null);
        return fill;
    }

    private HColor getTrueColor(String code, HColor colorForMonochrome) {
        HColorSimple result = (HColorSimple)HColorSet.instance().getColorOrWhite(code);
        if (colorForMonochrome == null) {
            return result;
        }
        HColorSimple color = (HColorSimple)colorForMonochrome;
        if (color.isGray()) {
            return result.asMonochrome();
        }
        return result.asMonochrome(color, this.minGray, this.maxGray);
    }

    private void drawCircle(UGraphicWithScale ugs, String s2, HColor colorForMonochrome) {
        ugs = this.applyFill(ugs, s2, colorForMonochrome);
        ugs = this.applyTransform(ugs, s2);
        double scalex = ugs.getAffineTransform().getScaleX();
        double scaley = ugs.getAffineTransform().getScaleY();
        double deltax = ugs.getAffineTransform().getTranslateX();
        double deltay = ugs.getAffineTransform().getTranslateY();
        double cx = Double.parseDouble(this.extractData("cx", s2)) * scalex;
        double cy = Double.parseDouble(this.extractData("cy", s2)) * scaley;
        double rx = Double.parseDouble(this.extractData("r", s2)) * scalex;
        double ry = Double.parseDouble(this.extractData("r", s2)) * scaley;
        UTranslate translate = new UTranslate(deltax + cx - rx, deltay + cy - ry);
        ugs.apply(translate).draw(new UEllipse(rx * 2.0, ry * 2.0));
    }

    private void drawEllipse(UGraphicWithScale ugs, String s2, HColor colorForMonochrome) {
        ugs = this.applyFill(ugs, s2, colorForMonochrome);
        ugs = this.applyTransform(ugs, s2);
        double scalex = ugs.getAffineTransform().getScaleX();
        double scaley = ugs.getAffineTransform().getScaleY();
        double deltax = ugs.getAffineTransform().getTranslateX();
        double deltay = ugs.getAffineTransform().getTranslateY();
        double cx = Double.parseDouble(this.extractData("cx", s2)) * scalex;
        double cy = Double.parseDouble(this.extractData("cy", s2)) * scaley;
        double rx = Double.parseDouble(this.extractData("rx", s2)) * scalex;
        double ry = Double.parseDouble(this.extractData("ry", s2)) * scaley;
        UTranslate translate = new UTranslate(deltax + cx - rx, deltay + cy - ry);
        ugs.apply(translate).draw(new UEllipse(rx * 2.0, ry * 2.0));
    }

    private void drawPath(UGraphicWithScale ugs, String s2, HColor colorForMonochrome) {
        s2 = s2.replace("id=\"", "ID=\"");
        ugs = this.applyFill(ugs, s2, colorForMonochrome);
        ugs = this.applyTransform(ugs, s2);
        int x1 = s2.indexOf("d=\"");
        int x2 = s2.indexOf(34, x1 + 3);
        String tmp = s2.substring(x1 + 3, x2);
        SvgPath svgPath = new SvgPath(tmp);
        svgPath.drawMe(ugs.getUg(), ugs.getAffineTransform());
    }

    private UGraphicWithScale applyTransform(UGraphicWithScale ugs, String s2) {
        String transform = this.extractData("transform", s2);
        if (transform == null) {
            return ugs;
        }
        if (transform.contains("rotate(")) {
            return this.applyRotate(ugs, transform);
        }
        if (transform.contains("matrix(")) {
            return this.applyMatrix(ugs, transform);
        }
        double[] scale = this.getScale(transform);
        UTranslate translate = this.getTranslate(transform);
        ugs = ugs.applyTranslate(translate.getDx(), translate.getDy());
        return ugs.applyScale(scale[0], scale[1]);
    }

    private UGraphicWithScale applyMatrix(UGraphicWithScale ugs, String transform) {
        Pattern p3 = Pattern.compile("matrix\\(([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)\\)");
        Matcher m3 = p3.matcher(transform);
        if (m3.find()) {
            double v1 = Double.parseDouble(m3.group(1));
            double v2 = Double.parseDouble(m3.group(2));
            double v3 = Double.parseDouble(m3.group(3));
            double v4 = Double.parseDouble(m3.group(4));
            double v5 = Double.parseDouble(m3.group(5));
            double v6 = Double.parseDouble(m3.group(6));
            ugs = ugs.applyMatrix(v1, v2, v3, v4, v5, v6);
        } else {
            System.err.println("WARNING: " + transform);
        }
        return ugs;
    }

    private UGraphicWithScale applyRotate(UGraphicWithScale ugs, String transform) {
        Pattern p3 = Pattern.compile("rotate\\(([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)\\)");
        Matcher m3 = p3.matcher(transform);
        if (m3.find()) {
            double angle = Double.parseDouble(m3.group(1));
            double x = Double.parseDouble(m3.group(2));
            double y = Double.parseDouble(m3.group(3));
            ugs = ugs.applyRotate(angle, x, y);
        } else {
            System.err.println("WARNING: " + transform);
        }
        return ugs;
    }

    private UTranslate getTranslate(String transform) {
        double x = 0.0;
        double y = 0.0;
        Pattern p3 = Pattern.compile("translate\\(([-.0-9]+)[ ,]+([-.0-9]+)\\)");
        Matcher m3 = p3.matcher(transform);
        if (m3.find()) {
            x = Double.parseDouble(m3.group(1));
            y = Double.parseDouble(m3.group(2));
        } else {
            Pattern p4 = Pattern.compile("translate\\(([-.0-9]+)\\)");
            Matcher m4 = p4.matcher(transform);
            if (m4.find()) {
                x = Double.parseDouble(m4.group(1));
                y = Double.parseDouble(m4.group(1));
            }
        }
        return new UTranslate(x, y);
    }

    private double[] getScale(String transform) {
        double[] scale = new double[]{1.0, 1.0};
        Pattern p1 = Pattern.compile("scale\\(([-.0-9]+)\\)");
        Matcher m1 = p1.matcher(transform);
        if (m1.find()) {
            scale[0] = Double.parseDouble(m1.group(1));
            scale[1] = scale[0];
        } else {
            Pattern p2 = Pattern.compile("scale\\(([-.0-9]+)[ ,]+([-.0-9]+)\\)");
            Matcher m22 = p2.matcher(transform);
            if (m22.find()) {
                scale[0] = Double.parseDouble(m22.group(1));
                scale[1] = Double.parseDouble(m22.group(2));
            }
        }
        return scale;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    static {
        InputStream is = Dummy.class.getResourceAsStream("emoji.txt");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String s2 = null;
            while ((s2 = br.readLine()) != null) {
                new Emoji(s2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

