/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.util.EnumSet;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.graphic.AddStyle;
import znaishaded.net.sourceforge.plantuml.graphic.ColorAndSizeChange;
import znaishaded.net.sourceforge.plantuml.graphic.ColorChange;
import znaishaded.net.sourceforge.plantuml.graphic.ExposantChange;
import znaishaded.net.sourceforge.plantuml.graphic.FontFamilyChange;
import znaishaded.net.sourceforge.plantuml.graphic.FontPosition;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlCommand;
import znaishaded.net.sourceforge.plantuml.graphic.Img;
import znaishaded.net.sourceforge.plantuml.graphic.RemoveStyle;
import znaishaded.net.sourceforge.plantuml.graphic.ResetFont;
import znaishaded.net.sourceforge.plantuml.graphic.SizeChange;
import znaishaded.net.sourceforge.plantuml.graphic.Splitter;
import znaishaded.net.sourceforge.plantuml.graphic.SpriteCommand;
import znaishaded.net.sourceforge.plantuml.graphic.SvgAttributesChange;
import znaishaded.net.sourceforge.plantuml.graphic.Text;
import znaishaded.net.sourceforge.plantuml.graphic.TextLink;

class HtmlCommandFactory {
    static final Pattern2 addStyle;
    static final Pattern2 removeStyle;
    private Pattern2 htmlTag = MyPattern.cmpile(Splitter.htmlTag);

    HtmlCommandFactory() {
    }

    HtmlCommand getHtmlCommand(ThemeStyle themeStyle, String s2) {
        if (!this.htmlTag.matcher(s2).matches()) {
            return new Text(s2);
        }
        if (MyPattern.mtches(s2, "\\<img\\s+(src[%s]*=[%s]*[%q%g]?[^\\s%g>]+[%q%g]?[%s]*|vspace\\s*=\\s*[%q%g]?\\d+[%q%g]?\\s*|valign[%s]*=[%s]*[%q%g]?(top|middle|bottom)[%q%g]?[%s]*)+\\>")) {
            return Img.getInstance(s2, true);
        }
        if (MyPattern.mtches(s2, "\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>")) {
            return Img.getInstance(s2, false);
        }
        if (addStyle.matcher(s2).matches()) {
            return AddStyle.fromString(s2);
        }
        if (removeStyle.matcher(s2).matches()) {
            return new RemoveStyle(FontStyle.getStyle(s2));
        }
        if (MyPattern.mtches(s2, "\\<font(\\s+size[%s]*=[%s]*[%g]?\\d+[%g]?|[%s]+color[%s]*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>")) {
            return new ColorAndSizeChange(themeStyle, s2);
        }
        if (MyPattern.mtches(s2, "\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>")) {
            return new ColorChange(themeStyle, s2);
        }
        if (MyPattern.mtches(s2, "\\<size[\\s:]+(\\d+)[%s]*\\>")) {
            return new SizeChange(s2);
        }
        if (MyPattern.mtches(s2, "\\<sup\\>")) {
            return new ExposantChange(FontPosition.EXPOSANT);
        }
        if (MyPattern.mtches(s2, "\\<sub\\>")) {
            return new ExposantChange(FontPosition.INDICE);
        }
        if (MyPattern.mtches(s2, "\\</font\\>|\\</color\\>|\\</size\\>|\\</text\\>")) {
            return new ResetFont();
        }
        if (MyPattern.mtches(s2, "\\</sup\\>|\\</sub\\>")) {
            return new ExposantChange(FontPosition.NORMAL);
        }
        if (MyPattern.mtches(s2, "\\<font[\\s:]+([^>]+)/?\\>")) {
            return new FontFamilyChange(s2);
        }
        if (MyPattern.mtches(s2, "\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>")) {
            return new SpriteCommand(s2);
        }
        if (MyPattern.mtches(s2, "\\[\\[([^\\[\\]]+)\\]\\]")) {
            UrlBuilder urlBuilder = new UrlBuilder(null, UrlMode.STRICT);
            Url url = urlBuilder.getUrl(s2);
            url.setMember(true);
            return new TextLink(url);
        }
        if (MyPattern.mtches(s2, "\\<text[\\s:]+([^>]+)/?\\>")) {
            return new SvgAttributesChange(s2);
        }
        return null;
    }

    static {
        StringBuilder sbAddStyle = new StringBuilder();
        StringBuilder sbRemoveStyle = new StringBuilder();
        for (FontStyle style : EnumSet.allOf(FontStyle.class)) {
            if (sbAddStyle.length() > 0) {
                sbAddStyle.append('|');
                sbRemoveStyle.append('|');
            }
            sbAddStyle.append(style.getActivationPattern());
            sbRemoveStyle.append(style.getDeactivationPattern());
        }
        addStyle = MyPattern.cmpile(sbAddStyle.toString());
        removeStyle = MyPattern.cmpile(sbRemoveStyle.toString());
    }
}

