/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.mindmap;

import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.mindmap.IdeaShape;
import znaishaded.net.sourceforge.plantuml.mindmap.MindMapDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandMindMapPlus
extends SingleLineCommand2<MindMapDiagram> {
    public CommandMindMapPlus() {
        super(false, CommandMindMapPlus.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandMindMapPlus.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "([+-]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("SHAPE", "(_)?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("LABEL", "([^%s].*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(MindMapDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String type = arg.get("TYPE", 0);
        String label = arg.get("LABEL", 0);
        String stringColor = arg.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), stringColor);
        }
        Direction direction = type.contains("-") ? Direction.LEFT : Direction.RIGHT;
        return diagram.addIdea(backColor, type.length() - 1, Display.getWithNewlines(label), IdeaShape.fromDesc(arg.get("SHAPE", 0)), direction);
    }
}

