/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.nwdiag.next;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.nwdiag.VerticalLine;
import znaishaded.net.sourceforge.plantuml.nwdiag.core.NServer;
import znaishaded.net.sourceforge.plantuml.nwdiag.core.Network;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class LinkedElement {
    public static final int MAGIC = 15;
    private final TextBlock box;
    private final Network network;
    private final NServer server;
    private final Map<Network, TextBlock> conns;
    private final List<Network> networks;
    private final double topMargin;
    private final double marginAd = 10.0;

    public LinkedElement(double topMargin, NServer server, TextBlock box, Map<Network, TextBlock> conns, List<Network> networks) {
        this.topMargin = topMargin;
        this.networks = networks;
        this.box = box;
        this.network = server.getMainNetworkNext();
        this.server = server;
        this.conns = conns;
    }

    public boolean isLinkedTo(Network some) {
        return this.conns.containsKey(some);
    }

    private int marginBoxW() {
        return 15;
    }

    private double marginBoxH() {
        return this.topMargin;
    }

    public MinMax getMinMax(StringBounder stringBounder, double width, double height) {
        double xMiddle = width / 2.0;
        double yMiddle = height / 2.0;
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        double x1 = xMiddle - dimBox.getWidth() / 2.0;
        double y1 = yMiddle - dimBox.getHeight() / 2.0;
        double x2 = xMiddle + dimBox.getWidth() / 2.0;
        double y2 = yMiddle + dimBox.getHeight() / 2.0;
        return MinMax.getEmpty(false).addPoint(x1 - 5.0, y1 - 5.0).addPoint(x2 + 5.0, y2 + 5.0);
    }

    public void drawMe(UGraphic ug, double width, double height) {
        double xMiddle = width / 2.0;
        double yMiddle = height / 2.0;
        this.drawCenter(ug, this.box, xMiddle, yMiddle);
    }

    public void drawLinks(UGraphic ug, double xstart, double width, double height) {
        ug = ug.apply(UTranslate.dx(xstart));
        double ynet1 = this.network.getY();
        double yMiddle = height / 2.0;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        double alpha = yMiddle - dimBox.getHeight() / 2.0;
        double posLink1 = (yMiddle - dimBox.getHeight() / 2.0 - this.topMargin + 15.0) / 2.0;
        double xMiddle = width / 2.0;
        double xLinkPos = width / 2.0;
        TreeSet<Double> skip = new TreeSet<Double>();
        for (Network n : this.networks) {
            if (!(xstart + xMiddle > n.getXmin()) || !(xstart + xMiddle < n.getXmax())) continue;
            skip.add(n.getY());
        }
        if (this.server.printFirstLink()) {
            if (this.network.isVisible()) {
                new VerticalLine(ynet1 + 5.0, ynet1 + alpha, skip).drawU(ug.apply(UTranslate.dx(xLinkPos + this.network.magicDelta())));
            } else {
                new VerticalLine(ynet1, ynet1 + alpha, Collections.emptySet()).drawU(ug.apply(UTranslate.dx(xLinkPos + this.network.magicDelta())));
            }
        }
        this.drawCenter(ug, this.link1(), xMiddle + this.network.magicDelta(), ynet1 + posLink1);
        double seven = 9.0;
        double x = xLinkPos - (double)(this.conns.size() - 2) * 9.0 / 2.0;
        boolean first = true;
        for (Map.Entry<Network, TextBlock> ent : this.conns.entrySet()) {
            if (ent.getKey() == this.network) continue;
            double ynet2 = ent.getKey().getY();
            new VerticalLine(ynet1 + yMiddle + dimBox.getHeight() / 2.0, ynet2, skip).drawU(ug.apply(UTranslate.dx(x - ent.getKey().magicDelta())));
            double xtext = first && this.conns.size() > 2 ? x - ent.getValue().calculateDimension(stringBounder).getWidth() / 2.0 : x;
            this.drawCenter(ug, ent.getValue(), xtext - ent.getKey().magicDelta(), ynet2 - alpha / 2.0);
            x += 9.0;
            first = false;
        }
    }

    private TextBlock link1() {
        return this.conns.get(this.network);
    }

    private TextBlock link2() {
        int i = this.networks.indexOf(this.network);
        if (i == this.networks.size() - 1) {
            return null;
        }
        return this.conns.get(this.networks.get(i + 1));
    }

    private void drawCenter(UGraphic ug, TextBlock block, double x, double y) {
        if (block == null) {
            return;
        }
        Dimension2D dim = block.calculateDimension(ug.getStringBounder());
        block.drawU(ug.apply(new UTranslate(x - dim.getWidth() / 2.0, y - dim.getHeight() / 2.0)));
    }

    public Dimension2D naturalDimension(StringBounder stringBounder) {
        Dimension2D dimLink1 = this.link1() == null ? new Dimension2DDouble(0.0, 0.0) : this.link1().calculateDimension(stringBounder);
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        Dimension2D dimLink2 = this.link2() == null ? new Dimension2DDouble(0.0, 0.0) : this.link2().calculateDimension(stringBounder);
        double width = MathUtils.max(dimLink1.getWidth() + 20.0, dimBox.getWidth() + (double)(2 * this.marginBoxW()), dimLink2.getWidth() + 20.0);
        double height = dimLink1.getHeight() + 20.0 + 2.0 * this.marginBoxH() + dimBox.getHeight() + dimLink2.getHeight() + 20.0;
        return new Dimension2DDouble(width, height);
    }

    public final Network getNetwork() {
        return this.network;
    }

    public final NServer getServer() {
        return this.server;
    }
}

