/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.security.SImageIO;

public class Metadata {
    public static void main(String[] args) throws IOException {
        Metadata meta = new Metadata();
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            meta.readAndDisplayMetadata(new SFile(args[i]));
        }
    }

    public void readAndDisplayMetadata(SFile file) throws IOException {
        ImageInputStream iis = SImageIO.createImageInputStream(file);
        Iterator<ImageReader> readers = SImageIO.getImageReaders(iis);
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            reader.setInput(iis, true);
            IIOMetadata metadata = reader.getImageMetadata(0);
            String[] names = metadata.getMetadataFormatNames();
            int length = names.length;
            for (int i = 0; i < length; ++i) {
                this.displayMetadata(metadata.getAsTree(names[i]));
            }
        }
    }

    private void displayMetadata(Node root) {
        this.displayMetadata(root, 0);
    }

    private void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("    ");
        }
    }

    private void displayMetadata(Node node, int level) {
        Node child;
        this.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) == null) {
            System.out.println("/>");
            return;
        }
        System.out.println(">");
        while (child != null) {
            this.displayMetadata(child, level + 1);
            child = child.getNextSibling();
        }
        this.indent(level);
        System.out.println("</" + node.getNodeName() + ">");
    }
}

