/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.security.SImageIO;

public class MetadataTag {
    private final Object source;
    private final String tag;

    public MetadataTag(SFile file, String tag) throws FileNotFoundException {
        this.source = file.conv();
        this.tag = tag;
    }

    public MetadataTag(File file, String tag) {
        this.source = file;
        this.tag = tag;
    }

    public MetadataTag(InputStream is, String tag) {
        this.source = is;
        this.tag = tag;
    }

    public String getData() throws IOException {
        ImageInputStream iis = SImageIO.createImageInputStream(this.source);
        Iterator<ImageReader> readers = SImageIO.getImageReaders(iis);
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            reader.setInput(iis, true);
            IIOMetadata metadata = reader.getImageMetadata(0);
            String[] names = metadata.getMetadataFormatNames();
            int length = names.length;
            for (int i = 0; i < length; ++i) {
                String result = this.displayMetadata(metadata.getAsTree(names[i]));
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private String displayMetadata(Node root) {
        return this.displayMetadata(root, 0);
    }

    private String displayMetadata(Node node, int level) {
        Node text;
        Node keyword;
        NamedNodeMap map = node.getAttributes();
        if (map != null && (keyword = map.getNamedItem("keyword")) != null && this.tag.equals(keyword.getNodeValue()) && (text = map.getNamedItem("value")) != null) {
            return text.getNodeValue();
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String result = this.displayMetadata(child, level + 1);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

