/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.posimo.Block;
import znaishaded.net.sourceforge.plantuml.posimo.Cluster;
import znaishaded.net.sourceforge.plantuml.posimo.IEntityImageBlock;
import znaishaded.net.sourceforge.plantuml.posimo.Positionable;

public class MargedBlock {
    private final Block block;
    private final IEntityImageBlock imageBlock;
    private final double marginDecorator;
    private final Dimension2D imageDimension;
    private static int uid = 1;

    public MargedBlock(StringBounder stringBounder, IEntityImageBlock imageBlock, double marginDecorator, Cluster parent) {
        this.imageBlock = imageBlock;
        this.marginDecorator = marginDecorator;
        this.imageDimension = imageBlock.getDimension(stringBounder);
        this.block = new Block(uid++, this.imageDimension.getWidth() + 2.0 * marginDecorator, this.imageDimension.getHeight() + 2.0 * marginDecorator, parent);
    }

    public Block getBlock() {
        return this.block;
    }

    public double getMarginDecorator() {
        return this.marginDecorator;
    }

    public IEntityImageBlock getImageBlock() {
        return this.imageBlock;
    }

    public Positionable getImagePosition() {
        return new Positionable(){

            @Override
            public Dimension2D getSize() {
                return MargedBlock.this.imageDimension;
            }

            @Override
            public Point2D getPosition() {
                Point2D pos = MargedBlock.this.block.getPosition();
                return new Point2D.Double(pos.getX() + MargedBlock.this.marginDecorator, pos.getY() + MargedBlock.this.marginDecorator);
            }

            @Override
            public void moveSvek(double deltaX, double deltaY) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

