/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project;

import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.WithLinkType;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.project.GanttArrow;
import znaishaded.net.sourceforge.plantuml.project.ToTaskDraw;
import znaishaded.net.sourceforge.plantuml.project.core.Task;
import znaishaded.net.sourceforge.plantuml.project.core.TaskAttribute;
import znaishaded.net.sourceforge.plantuml.project.core.TaskInstant;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class GanttConstraint
extends WithLinkType {
    private final TaskInstant source;
    private final TaskInstant dest;
    private final StyleBuilder styleBuilder;
    private final HColorSet colorSet;

    public GanttConstraint(HColorSet colorSet, StyleBuilder styleBuilder, TaskInstant source, TaskInstant dest, HColor forcedColor) {
        this.styleBuilder = styleBuilder;
        this.colorSet = colorSet;
        this.source = source;
        this.dest = dest;
        this.type = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        this.setSpecificColor(forcedColor);
    }

    public GanttConstraint(HColorSet colorSet, StyleBuilder styleBuilder, TaskInstant source, TaskInstant dest) {
        this(colorSet, styleBuilder, source, dest, null);
    }

    public boolean isOn(Task task) {
        return this.source.getMoment() == task || this.dest.getMoment() == task;
    }

    public boolean isThereRightArrow(Task task) {
        if (this.dest.getMoment() == task && this.dest.getAttribute() == TaskAttribute.END) {
            return true;
        }
        return this.source.getMoment() == task && this.dest.getAttribute() == TaskAttribute.END && this.source.getAttribute() == TaskAttribute.END;
    }

    public String toString() {
        return this.source.toString() + " --> " + this.dest.toString();
    }

    public final StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.arrow);
    }

    public UDrawable getUDrawable(TimeScale timeScale, ToTaskDraw toTaskDraw) {
        Style style = this.getStyleSignature().getMergedStyle(this.styleBuilder).eventuallyOverride(PName.LineColor, this.getSpecificColor());
        style = style.eventuallyOverride(this.getType().getStroke3(style.getStroke()));
        return new GanttArrow(this.colorSet, style, timeScale, this.source, this.dest, toTaskDraw, this.styleBuilder);
    }

    public boolean isHidden(Day min2, Day max) {
        if (this.isHidden(this.source.getInstantPrecise(), min2, max)) {
            return true;
        }
        return this.isHidden(this.dest.getInstantPrecise(), min2, max);
    }

    private boolean isHidden(Day now, Day min2, Day max) {
        if (now.compareTo(min2) < 0) {
            return true;
        }
        return now.compareTo(max) > 0;
    }

    @Override
    public void goNorank() {
    }
}

