/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.draw;

import java.util.Locale;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.project.LoadPlanable;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.time.MonthYear;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class TimeHeaderYearly
extends TimeHeaderCalendar {
    @Override
    public double getTimeHeaderHeight() {
        return 20.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 19.0;
    }

    public TimeHeaderYearly(Locale locale, Style timelineStyle, Style closedStyle, double scale, Day calendar, Day min2, Day max, LoadPlanable defaultPlan, Map<Day, HColor> colorDays, Map<DayOfWeek, HColor> colorDaysOfWeek, HColorSet colorSet, ThemeStyle themeStyle) {
        super(locale, timelineStyle, closedStyle, calendar, min2, max, defaultPlan, colorDays, colorDaysOfWeek, new TimeScaleCompressed(calendar, scale), colorSet, themeStyle);
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawYears(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawYears(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getTimeFooterHeight());
    }

    private void drawYears(UGraphic ug) {
        MonthYear last = null;
        double lastChange = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (last == null || wink.monthYear().year() != last.year()) {
                this.drawVbar(ug, x1, 0.0, 19.0);
                if (last != null) {
                    this.printYear(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChange) {
            this.printYear(ug, last, lastChange, x1);
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), 0.0, 19.0);
    }

    private void printYear(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock("" + monthYear.year(), 14, true, this.openFontColor());
        this.printCentered(ug, true, start, end, small);
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight();
    }
}

