/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementLine
extends AbstractElement {
    private final char separator;

    public ElementLine(char separator) {
        this.separator = separator;
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        return new Dimension2DDouble(10.0, 6.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        ug = ug.apply(this.getColorAA());
        double y2 = dimToUse.getHeight() / 2.0;
        if (this.separator == '=') {
            y2 -= 1.0;
        }
        ElementLine.drawLine(ug, 0.0, y2, dimToUse.getWidth(), this.separator);
    }

    private static void drawLine(UGraphic ug, double x, double y, double widthToUse, char separator) {
        if (separator == '=') {
            ug.apply(new UStroke()).apply(new UTranslate(x, y)).draw(ULine.hline(widthToUse));
            ug.apply(new UStroke()).apply(new UTranslate(x, y + 2.0)).draw(ULine.hline(widthToUse));
        } else if (separator == '.') {
            ug.apply(new UStroke(1.0, 2.0, 1.0)).apply(new UTranslate(x, y)).draw(ULine.hline(widthToUse));
        } else if (separator == '-') {
            ug.apply(new UStroke()).apply(new UTranslate(x, y)).draw(ULine.hline(widthToUse));
        } else {
            ug.apply(new UStroke(1.5)).apply(new UTranslate(x, y)).draw(ULine.hline(widthToUse));
        }
    }
}

