/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.ParticipantType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandParticipantMultilines
extends CommandMultilines2<SequenceDiagram> {
    public CommandParticipantMultilines() {
        super(CommandParticipantMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "^([^\\[\\]]*)\\]$";
    }

    private static RegexConcat getRegexConcat() {
        return RegexConcat.build(CommandParticipantMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(participant)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([%pLN_.@]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\["), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(SequenceDiagram diagram, BlocLines lines) throws NoSuchColorException {
        String urlString;
        RegexResult arg = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String code = arg.get("CODE", 0);
        if (diagram.participantsContainsKey(code)) {
            diagram.putParticipantInLast(code);
            return CommandExecutionResult.ok();
        }
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        Display strings = lines.toDisplay();
        ParticipantType type = ParticipantType.PARTICIPANT;
        boolean create = false;
        boolean order = false;
        Participant participant = diagram.createNewParticipant(type, code, strings, 0);
        String stereotype = arg.get("STEREO", 0);
        if (stereotype != null) {
            ISkinParam skinParam = diagram.getSkinParam();
            boolean stereotypePositionTop = skinParam.stereotypePositionTop();
            UFont font = skinParam.getFont(null, false, FontParam.CIRCLED_CHARACTER);
            participant.setStereotype(Stereotype.build(stereotype, skinParam.getCircledCharacterRadius(), font, diagram.getSkinParam().getIHtmlColorSet()), stereotypePositionTop);
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            participant.setUrl(url);
        }
        return CommandExecutionResult.ok();
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }
}

