/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.GraphicalDelayText;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Pushable;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.SimpleContext2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class ParticipantBox
implements Pushable {
    private static int CPT = 0;
    private final int outMargin;
    private double startingX;
    private final Component head;
    private final Component line;
    private final Component tail;
    private final Component delayLine;
    private int cpt = CPT++;
    private final List<GraphicalDelayText> delays = new ArrayList<GraphicalDelayText>();

    public ParticipantBox(Component head, Component line, Component tail, Component delayLine, double startingX, int outMargin) {
        this.outMargin = outMargin;
        this.startingX = startingX;
        this.head = head;
        this.line = line;
        this.tail = tail;
        this.delayLine = delayLine;
    }

    public String toString() {
        return "PB" + this.cpt;
    }

    public double getMinX() {
        return this.startingX + (double)this.outMargin;
    }

    public double getMaxX(StringBounder stringBounder) {
        return this.startingX + this.head.getPreferredWidth(stringBounder) + (double)(2 * this.outMargin);
    }

    @Override
    public double getCenterX(StringBounder stringBounder) {
        return this.startingX + this.head.getPreferredWidth(stringBounder) / 2.0 + (double)this.outMargin;
    }

    public double getHeadHeight(StringBounder stringBounder) {
        return this.head.getPreferredHeight(stringBounder) + this.line.getPreferredHeight(stringBounder) / 2.0;
    }

    public double getHeadHeightOnly(StringBounder stringBounder) {
        return this.head.getPreferredHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.head.getPreferredWidth(stringBounder);
    }

    public double getTailHeight(StringBounder stringBounder) {
        return this.tail.getPreferredHeight(stringBounder) + this.line.getPreferredHeight(stringBounder) / 2.0;
    }

    @Override
    public void pushToLeft(double deltaX) {
        this.startingX += deltaX;
    }

    public void drawHeadTailU(UGraphic ug, double topStartingY, boolean showHead, double positionTail) {
        if (topStartingY == 0.0) {
            throw new IllegalStateException("setTopStartingY cannot be zero");
        }
        StringBounder stringBounder = ug.getStringBounder();
        if (showHead) {
            double y1 = topStartingY - this.head.getPreferredHeight(stringBounder) - this.line.getPreferredHeight(stringBounder) / 2.0;
            this.head.drawU(ug.apply(new UTranslate(this.getMinX(), y1)), new Area(new Dimension2DDouble(this.head.getPreferredWidth(stringBounder), this.head.getPreferredHeight(stringBounder))), new SimpleContext2D(false));
        }
        if (positionTail > 0.0) {
            ug = ug.apply(new UTranslate(this.getMinX(), positionTail += this.line.getPreferredHeight(stringBounder) / 2.0 - 1.0));
            this.tail.drawU(ug, new Area(new Dimension2DDouble(this.tail.getPreferredWidth(stringBounder), this.tail.getPreferredHeight(stringBounder))), new SimpleContext2D(false));
        }
    }

    public void drawParticipantHead(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        this.head.drawU(ug.apply(UTranslate.dx(this.outMargin)), new Area(new Dimension2DDouble(this.head.getPreferredWidth(stringBounder), this.head.getPreferredHeight(stringBounder))), new SimpleContext2D(false));
    }

    public void drawLineU22(UGraphic ug, double startingY, double endingY, boolean showTail, double myDelta) {
        ug = ug.apply(UTranslate.dx(this.startingX));
        if (this.delays.size() > 0) {
            StringBounder stringBounder = ug.getStringBounder();
            for (GraphicalDelayText delay : this.delays) {
                if (!(delay.getStartingY() - myDelta >= startingY)) continue;
                this.drawLineIfLowerThan(ug, startingY, delay.getStartingY() - myDelta, this.line, endingY);
                this.drawLineIfLowerThan(ug, delay.getStartingY() - myDelta, delay.getEndingY(stringBounder) - myDelta, this.delayLine, endingY);
                startingY = delay.getEndingY(stringBounder) - myDelta;
            }
            if (this.delays.get(this.delays.size() - 1).getEndingY(stringBounder) - myDelta > startingY) {
                startingY = this.delays.get(this.delays.size() - 1).getEndingY(stringBounder) - myDelta;
            }
        }
        this.drawLineIfLowerThan(ug, startingY, endingY, this.line, endingY);
    }

    private void drawLineIfLowerThan(UGraphic ug, double startingY, double endingY, Component comp, double limitY) {
        startingY = Math.min(startingY, limitY);
        endingY = Math.min(endingY, limitY);
        if (startingY < limitY || endingY < limitY) {
            this.drawLine(ug, startingY, endingY, comp);
        }
    }

    private void drawLine(UGraphic ug, double startingY, double endingY, Component comp) {
        StringBounder stringBounder = ug.getStringBounder();
        comp.drawU(ug.apply(UTranslate.dy(startingY)), new Area(new Dimension2DDouble(this.head.getPreferredWidth(stringBounder) + (double)(this.outMargin * 2), endingY - startingY)), new SimpleContext2D(false));
    }

    public double magicMargin(StringBounder stringBounder) {
        return this.line.getPreferredHeight(stringBounder) / 2.0;
    }

    public double getStartingX() {
        return this.startingX;
    }

    public void addDelay(GraphicalDelayText delay) {
        this.delays.add(delay);
    }

    @Override
    public Collection<Segment> getDelays(final StringBounder stringBounder) {
        return new AbstractCollection<Segment>(){

            @Override
            public Iterator<Segment> iterator() {
                return new Iterator<Segment>(){
                    private final Iterator<GraphicalDelayText> it;
                    {
                        this.it = ParticipantBox.this.delays.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Segment next() {
                        GraphicalDelayText d = this.it.next();
                        return new Segment(d.getStartingY(), d.getEndingY(stringBounder));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ParticipantBox.this.delays.size();
            }
        };
    }
}

