/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.command;

import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Player;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandDefineStateShort
extends SingleLineCommand2<TimingDiagram> {
    public CommandDefineStateShort() {
        super(CommandDefineStateShort.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandDefineStateShort.class.getName(), RegexLeaf.start(), new RegexLeaf("PLAYER", "([%pLN_.@]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("has"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("STATE", "([%pLN_.@]+)"), new RegexLeaf("STATES", "((,([%pLN_.@]+))*)"), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        String playerCode = arg.get("PLAYER", 0);
        Player player = diagram.getPlayer(playerCode);
        if (player == null) {
            return CommandExecutionResult.error("Unknown " + playerCode);
        }
        String stateCode = arg.get("STATE", 0);
        player.defineState(stateCode, stateCode);
        String states = arg.get("STATES", 0);
        if (states != null) {
            StringTokenizer st = new StringTokenizer(states, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                player.defineState(token, token);
            }
        }
        return CommandExecutionResult.ok();
    }
}

