/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegment;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegmentType;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.ExtendedGeneralPath;

public class DriverPathG2d
extends DriverShadowedG2d
implements UDriver<UPath, Graphics2D> {
    private final double dpiFactor;

    public DriverPathG2d(double dpiFactor) {
        this.dpiFactor = dpiFactor;
    }

    @Override
    public void draw(UPath shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        DriverLineG2d.manageStroke(param, g2d);
        HColor back = param.getBackcolor();
        ExtendedGeneralPath p = new ExtendedGeneralPath();
        MinMax minMax = MinMax.getEmpty(false);
        minMax = minMax.addPoint(x, y);
        for (USegment seg : shape) {
            USegmentType type = seg.getSegmentType();
            double[] coord = seg.getCoord();
            if (type == USegmentType.SEG_MOVETO) {
                p.moveTo(x + coord[0], y + coord[1]);
                minMax = minMax.addPoint(x + coord[0], y + coord[1]);
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                p.lineTo(x + coord[0], y + coord[1]);
                minMax = minMax.addPoint(x + coord[0], y + coord[1]);
                continue;
            }
            if (type == USegmentType.SEG_CUBICTO) {
                p.curveTo(x + coord[0], y + coord[1], x + coord[2], y + coord[3], x + coord[4], y + coord[5]);
                minMax = minMax.addPoint(x + coord[4], y + coord[5]);
                continue;
            }
            if (type == USegmentType.SEG_ARCTO) {
                p.arcTo(coord[0], coord[1], coord[2], coord[3] != 0.0, coord[4] != 0.0, x + coord[5], y + coord[6]);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if (shape.isOpenIconic()) {
            p.closePath();
            g2d.setColor(mapper.toColor(param.getColor()));
            g2d.fill(p);
            return;
        }
        if (shape.getDeltaShadow() != 0.0) {
            if (back == null || HColorUtils.isTransparent(back)) {
                this.drawOnlyLineShadowSpecial(g2d, p, shape.getDeltaShadow(), this.dpiFactor);
            } else {
                this.drawShadow(g2d, p, shape.getDeltaShadow(), this.dpiFactor);
            }
        }
        if (back instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)back;
            char policy = gr.getPolicy();
            GradientPaint paint = policy == '|' ? new GradientPaint((float)minMax.getMinX(), (float)minMax.getMaxY() / 2.0f, mapper.toColor(gr.getColor1()), (float)minMax.getMaxX(), (float)minMax.getMaxY() / 2.0f, mapper.toColor(gr.getColor2())) : (policy == '\\' ? new GradientPaint((float)minMax.getMinX(), (float)minMax.getMaxY(), mapper.toColor(gr.getColor1()), (float)minMax.getMaxX(), (float)minMax.getMinY(), mapper.toColor(gr.getColor2())) : (policy == '-' ? new GradientPaint((float)minMax.getMaxX() / 2.0f, (float)minMax.getMinY(), mapper.toColor(gr.getColor1()), (float)minMax.getMaxX() / 2.0f, (float)minMax.getMaxY(), mapper.toColor(gr.getColor2())) : new GradientPaint((float)x, (float)y, mapper.toColor(gr.getColor1()), (float)minMax.getMaxX(), (float)minMax.getMaxY(), mapper.toColor(gr.getColor2()))));
            g2d.setPaint(paint);
            g2d.fill(p);
        } else if (back != null) {
            g2d.setColor(mapper.toColor(back));
            g2d.fill(p);
        }
        if (param.getColor() != null) {
            g2d.setColor(mapper.toColor(param.getColor()));
            g2d.draw(p);
        }
    }
}

