/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import znaishaded.org.apache.ant.compress.resources.SevenZFileSet;
import znaishaded.org.apache.ant.compress.taskdefs.ArchiveBase;
import znaishaded.org.apache.ant.compress.util.SevenZStreamFactory;
import znaishaded.org.apache.commons.compress.archivers.ArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.ArchiveOutputStream;
import znaishaded.org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import znaishaded.org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.types.ArchiveFileSet;
import znaishaded.org.apache.tools.ant.types.Resource;

public class SevenZ
extends ArchiveBase {
    private boolean keepCompression = false;
    private String contentCompression;
    private List<SevenZMethodConfiguration> contentMethods;

    public SevenZ() {
        this.setFactory(new SevenZStreamFactory(){

            @Override
            public ArchiveOutputStream getArchiveOutputStream(File f, String encoding) throws IOException {
                SevenZStreamFactory.SevenZArchiveOutputStream o = (SevenZStreamFactory.SevenZArchiveOutputStream)super.getArchiveOutputStream(f, encoding);
                if (SevenZ.this.contentCompression != null) {
                    o.setContentCompression(SevenZ.asMethod(SevenZ.this.contentCompression));
                }
                if (SevenZ.this.contentMethods != null) {
                    o.setContentMethods(SevenZ.this.contentMethods);
                }
                return o;
            }
        });
        this.setEntryBuilder(new ArchiveBase.EntryBuilder(){

            @Override
            public ArchiveEntry buildEntry(ArchiveBase.ResourceWithFlags r) {
                SevenZArchiveEntry entry = new SevenZArchiveEntry();
                entry.setName(r.getName());
                entry.setDirectory(r.getResource().isDirectory());
                entry.setLastModifiedDate(new Date(r.getResource().getLastModified()));
                entry.setSize(r.getResource().getSize());
                if (SevenZ.this.keepCompression && r.getResourceFlags().hasContentMethods()) {
                    entry.setContentMethods(r.getResourceFlags().getContentMethods());
                }
                return entry;
            }
        });
        this.setFileSetBuilder(new ArchiveBase.FileSetBuilder(){

            @Override
            public ArchiveFileSet buildFileSet(Resource dest) {
                SevenZFileSet afs = new SevenZFileSet();
                afs.setSrcResource(dest);
                return afs;
            }
        });
    }

    public void setContentCompression(String method) {
        if (this.contentMethods != null && method != null) {
            throw new BuildException("you must not specify contentCompression and nested contentMethod elements at the same time");
        }
        this.contentCompression = method;
    }

    public void addConfiguredContentMethod(ContentMethod cm) {
        if (this.contentCompression != null) {
            throw new BuildException("you must not specify contentCompression and nested contentMethod elements at the same time");
        }
        if (this.contentMethods == null) {
            this.contentMethods = new ArrayList<SevenZMethodConfiguration>();
        }
        this.contentMethods.add(SevenZ.asMethodConfiguration(cm));
    }

    public void setKeepCompression(boolean keep) {
        this.keepCompression = keep;
    }

    private static SevenZMethod asMethod(String method) {
        return Enum.valueOf(SevenZMethod.class, method.toUpperCase(Locale.US));
    }

    private static SevenZMethodConfiguration asMethodConfiguration(ContentMethod cm) {
        return new SevenZMethodConfiguration(SevenZ.asMethod(cm.method), cm.option);
    }

    public static class ContentMethod {
        private String method;
        private Integer option;

        public void setMethod(String m3) {
            this.method = m3;
        }

        public void setOption(int o) {
            this.option = o;
        }
    }
}

