/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

class RegionScopeExtractor {
    private final String[] lines;
    private final int startLineIdx;
    private final char scopeStart;
    private final char scopeEnd;
    private boolean insideSingleQuote;
    private boolean insideDoubleQuote;
    private int resultStartLineIdx;
    private int resultEndLineIdx;

    RegionScopeExtractor(String[] lines, int startLineIdx, char scopeStart, char scopeEnd) {
        this.lines = lines;
        this.startLineIdx = startLineIdx;
        this.scopeStart = scopeStart;
        this.scopeEnd = scopeEnd;
    }

    public int getResultStartLineIdx() {
        return this.resultStartLineIdx;
    }

    public int getResultEndLineIdx() {
        return this.resultEndLineIdx;
    }

    void process() {
        int scopeBalance = 0;
        boolean encounteredScopeStart = false;
        this.resultStartLineIdx = this.startLineIdx;
        this.resultEndLineIdx = -1;
        for (int lineIdx = this.startLineIdx; lineIdx < this.lines.length; ++lineIdx) {
            String line = this.lines[lineIdx];
            int previousChar = 32;
            for (int charIdx = 0; charIdx < line.length(); ++charIdx) {
                boolean isPreviousCharEscape;
                char c = line.charAt(charIdx);
                if (!this.insideSingleQuote && !this.insideDoubleQuote) {
                    if (c == this.scopeStart) {
                        encounteredScopeStart = true;
                        ++scopeBalance;
                    } else if (c == this.scopeEnd && --scopeBalance == 0 && encounteredScopeStart) {
                        this.resultEndLineIdx = lineIdx;
                        return;
                    }
                }
                boolean bl = isPreviousCharEscape = previousChar == 92;
                if (c == '\"' && !isPreviousCharEscape) {
                    boolean bl2 = this.insideDoubleQuote = !this.insideDoubleQuote;
                }
                if (c == '\'' && !isPreviousCharEscape) {
                    this.insideSingleQuote = !this.insideSingleQuote;
                }
                previousChar = c;
            }
        }
    }
}

