/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.python.PythonFileNameAndRelativeName;
import org.testingisdocumenting.znai.resources.ResourcesResolver;

class PythonUtils {
    PythonUtils() {
    }

    static PythonFileNameAndRelativeName findFileNameAndRelativeNameByFullyQualifiedName(ResourcesResolver resourcesResolver, String fullyQualifiedName) {
        List<PythonFileNameAndRelativeName> fileAndNames = PythonUtils.entityNameFileNameCombos(fullyQualifiedName);
        return fileAndNames.stream().filter(fn -> resourcesResolver.canResolve(fn.getFileName())).findFirst().orElseThrow(() -> new IllegalArgumentException("can't find any of <" + fileAndNames.stream().map(PythonFileNameAndRelativeName::getFileName).collect(Collectors.joining(", ")) + ">, tried locations:\n  " + String.join((CharSequence)"\n  ", resourcesResolver.listOfTriedLocations(""))));
    }

    static String globalAnchorId(String id) {
        return "python_api_" + id.replaceAll("\\.", "_");
    }

    static String convertQualifiedNameToFilePath(String qualifiedName) {
        String[] parts = PythonUtils.splitIntoParts(qualifiedName);
        return PythonUtils.combineFileNameParts(parts, 1);
    }

    static PropertyNameAndQualifier extractPropertyNameAndQualifierFromEntryName(String entryName) {
        String[] parts = entryName.split("\\.");
        if (parts.length < 3) {
            throw new IllegalArgumentException("expect raw property to match [packageName.]ClassName.propertyName.[get|set]");
        }
        return new PropertyNameAndQualifier(parts[parts.length - 2], parts[parts.length - 1]);
    }

    static List<String> convertQualifiedNameToMultipleFilePaths(String qualifiedName) {
        String[] parts = PythonUtils.splitIntoParts(qualifiedName);
        ArrayList<String> result = new ArrayList<String>();
        for (int partsToOmit = 1; partsToOmit < parts.length; ++partsToOmit) {
            result.add(PythonUtils.combineFileNameParts(parts, partsToOmit));
        }
        return result;
    }

    static String entityNameFromQualifiedName(String qualifiedName) {
        String[] parts = qualifiedName.split("\\.");
        return parts[parts.length - 1];
    }

    static List<PythonFileNameAndRelativeName> entityNameFileNameCombos(String qualifiedName) {
        String[] parts = qualifiedName.split("\\.");
        ArrayList<PythonFileNameAndRelativeName> result = new ArrayList<PythonFileNameAndRelativeName>();
        for (int namePartsToUse = 1; namePartsToUse < parts.length; ++namePartsToUse) {
            String relativeName = Arrays.stream(parts).skip(parts.length - namePartsToUse).collect(Collectors.joining("."));
            String fileName = PythonUtils.combineFileNameParts(parts, namePartsToUse);
            String packageName = PythonUtils.combinePackageNameParts(parts, namePartsToUse);
            result.add(new PythonFileNameAndRelativeName(fileName, packageName, relativeName));
        }
        return result;
    }

    private static String combineFileNameParts(String[] parts, int partsToOmit) {
        return Arrays.stream(parts).limit(parts.length - partsToOmit).collect(Collectors.joining("/")) + ".py";
    }

    private static String combinePackageNameParts(String[] parts, int partsToOmit) {
        return Arrays.stream(parts).limit(parts.length - partsToOmit).collect(Collectors.joining("."));
    }

    private static String[] splitIntoParts(String qualifiedName) {
        String[] parts = qualifiedName.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("expect the qualified name to be of a form: module.[optional.].name, given: " + qualifiedName);
        }
        return parts;
    }

    public static class PropertyNameAndQualifier {
        private final String name;
        private final String qualifier;

        public PropertyNameAndQualifier(String name, String qualifier) {
            this.name = name;
            this.qualifier = qualifier;
        }

        public String getName() {
            return this.name;
        }

        public String getQualifier() {
            return this.qualifier;
        }
    }
}

