/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.util.Arrays;
import java.util.List;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocGenerator;
import org.testingisdocumenting.znai.structure.TocNameAndOpts;

public class PlainTextTocGenerator
implements TocGenerator {
    @Override
    public TableOfContents generate(String textContent) {
        return new Parser(textContent).parse();
    }

    private static class Parser {
        public static final String INDENTATION = "    ";
        private final List<String> lines;
        private TocNameAndOpts currentChapter;
        private final TableOfContents toc;

        public Parser(String nestedText) {
            this.lines = Arrays.asList(nestedText.replace("\r", "").split("\n"));
            this.toc = new TableOfContents();
        }

        public TableOfContents parse() {
            this.lines.forEach(this::parse);
            return this.toc;
        }

        private void parse(String line) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                return;
            }
            if (line.startsWith(INDENTATION)) {
                this.handlePageEntry(trimmedLine);
            } else if (line.startsWith(" ")) {
                this.handleSyntaxError();
            } else {
                this.handleChapterEntry(trimmedLine);
            }
        }

        private void handleSyntaxError() {
            throw new IllegalArgumentException("toc line should either start with " + INDENTATION.length() + " spaces to denote page file name, or start without spaces to denote chapter dir name");
        }

        private void handleChapterEntry(String trimmedLine) {
            this.currentChapter = new TocNameAndOpts(trimmedLine);
        }

        private void handlePageEntry(String line) {
            if (this.currentChapter == null) {
                throw new IllegalArgumentException("chapter is not specified, use a line without indentation to specify a chapter");
            }
            this.toc.addTocItem(this.currentChapter, line);
        }
    }
}

