/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonpatch;

import znaishaded.com.fasterxml.jackson.annotation.JsonCreator;
import znaishaded.com.fasterxml.jackson.annotation.JsonProperty;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.ArrayNode;
import znaishaded.com.fasterxml.jackson.databind.node.ObjectNode;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jackson.jsonpointer.ReferenceToken;
import znaishaded.com.github.fge.jackson.jsonpointer.TokenResolver;
import znaishaded.com.github.fge.jsonpatch.Iterables;
import znaishaded.com.github.fge.jsonpatch.JsonPatchException;
import znaishaded.com.github.fge.jsonpatch.PathValueOperation;

public final class AddOperation
extends PathValueOperation {
    private static final ReferenceToken LAST_ARRAY_ELEMENT = ReferenceToken.fromRaw("-");

    @JsonCreator
    public AddOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super("add", path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return this.value;
        }
        JsonNode parentNode = this.path.parent().path(node);
        if (parentNode.isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchParent"));
        }
        if (!parentNode.isContainerNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.parentNotContainer"));
        }
        return parentNode.isArray() ? this.addToArray(this.path, node) : this.addToObject(this.path, node);
    }

    private JsonNode addToArray(JsonPointer path, JsonNode node) throws JsonPatchException {
        int index;
        Object ret = node.deepCopy();
        ArrayNode target = (ArrayNode)path.parent().get(ret);
        TokenResolver<JsonNode> token = Iterables.getLast(path);
        if (token.getToken().equals(LAST_ARRAY_ELEMENT)) {
            target.add(this.value);
            return ret;
        }
        int size = target.size();
        try {
            index = Integer.parseInt(token.toString());
        }
        catch (NumberFormatException ignored) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.notAnIndex"));
        }
        if (index < 0 || index > size) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchIndex"));
        }
        target.insert(index, this.value);
        return ret;
    }

    private JsonNode addToObject(JsonPointer path, JsonNode node) {
        TokenResolver<JsonNode> token = Iterables.getLast(path);
        Object ret = node.deepCopy();
        ObjectNode target = (ObjectNode)path.parent().get(ret);
        target.set(token.getToken().getRaw(), this.value);
        return ret;
    }
}

