/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers;

import java.util.Collection;
import java.util.EnumSet;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ExceptionProvider;
import znaishaded.com.github.fge.jsonschema.core.exceptions.InvalidSchemaException;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;

public abstract class AbstractSyntaxChecker
implements SyntaxChecker {
    private static final ExceptionProvider EXCEPTION_PROVIDER = new ExceptionProvider(){

        @Override
        public ProcessingException doException(ProcessingMessage message) {
            return new InvalidSchemaException(message);
        }
    };
    protected final String keyword;
    private final EnumSet<NodeType> types;

    protected AbstractSyntaxChecker(String keyword, NodeType first, NodeType ... other) {
        this.keyword = keyword;
        this.types = EnumSet.of(first, other);
    }

    @Override
    public final EnumSet<NodeType> getValidTypes() {
        return EnumSet.copyOf(this.types);
    }

    @Override
    public final void checkSyntax(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        NodeType type = NodeType.getNodeType(node);
        if (!this.types.contains((Object)type)) {
            report.error(this.newMsg(tree, bundle, "common.incorrectType").putArgument("found", type).putArgument("expected", this.types));
            return;
        }
        this.checkValue(pointers, bundle, report, tree);
    }

    protected abstract void checkValue(Collection<JsonPointer> var1, MessageBundle var2, ProcessingReport var3, SchemaTree var4) throws ProcessingException;

    protected final ProcessingMessage newMsg(SchemaTree tree, MessageBundle bundle, String key) {
        return new ProcessingMessage().setMessage(bundle.getMessage(key)).put("domain", "syntax").put("schema", tree).put("keyword", this.keyword).setExceptionProvider(EXCEPTION_PROVIDER);
    }

    protected final JsonNode getNode(SchemaTree tree) {
        return tree.getNode().get(this.keyword);
    }
}

