/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.msgsimple.load;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.IdentityHashMap;
import java.util.Map;
import znaishaded.com.github.fge.msgsimple.InternalBundle;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.load.MessageBundleLoader;

public final class MessageBundles {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    private static final Map<Class<? extends MessageBundleLoader>, MessageBundle> BUNDLES = new IdentityHashMap<Class<? extends MessageBundleLoader>, MessageBundle>();

    private MessageBundles() {
    }

    public static synchronized MessageBundle getBundle(Class<? extends MessageBundleLoader> c) {
        MessageBundle ret = BUNDLES.get(c);
        if (ret == null) {
            ret = MessageBundles.doGetBundle(c);
            BUNDLES.put(c, ret);
        }
        return ret;
    }

    private static MessageBundle doGetBundle(Class<? extends MessageBundleLoader> c) {
        MessageBundleLoader provider;
        Constructor<? extends MessageBundleLoader> constructor;
        String message = BUNDLE.getMessage("factory.noConstructor");
        try {
            constructor = c.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(message, e);
        }
        message = BUNDLE.getMessage("factory.cannotInstantiate");
        try {
            provider = constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(message, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(message, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(message, e);
        }
        return BUNDLE.checkNotNull(provider.getBundle(), "factory.illegalProvider");
    }
}

