/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.util;

import znaishaded.com.fasterxml.jackson.annotation.JsonInclude;
import znaishaded.com.fasterxml.jackson.core.JsonFactory;
import znaishaded.com.fasterxml.jackson.databind.DeserializationFeature;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.com.fasterxml.jackson.databind.SerializationFeature;
import znaishaded.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import znaishaded.io.swagger.jackson.mixin.OperationResponseMixin;
import znaishaded.io.swagger.jackson.mixin.ResponseSchemaMixin;
import znaishaded.io.swagger.models.Operation;
import znaishaded.io.swagger.models.Response;
import znaishaded.io.swagger.util.DeserializationModule;
import znaishaded.io.swagger.util.ReferenceSerializationConfigurer;

public class ObjectMapperFactory {
    protected static ObjectMapper createJson() {
        return ObjectMapperFactory.createJson(true, true);
    }

    protected static ObjectMapper createJson(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(null, includePathDeserializer, includeResponseDeserializer);
    }

    protected static ObjectMapper createYaml() {
        return ObjectMapperFactory.createYaml(true, true);
    }

    protected static ObjectMapper createYaml(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(new YAMLFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    private static ObjectMapper create(JsonFactory jsonFactory, boolean includePathDeserializer, boolean includeResponseDeserializer) {
        ObjectMapper mapper = jsonFactory == null ? new ObjectMapper() : new ObjectMapper(jsonFactory);
        DeserializationModule deserializerModule = new DeserializationModule(includePathDeserializer, includeResponseDeserializer);
        mapper.registerModule(deserializerModule);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.addMixIn(Response.class, ResponseSchemaMixin.class);
        mapper.addMixIn(Operation.class, OperationResponseMixin.class);
        ReferenceSerializationConfigurer.serializeAsComputedRef(mapper);
        return mapper;
    }
}

