/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.auth.AuthProvider;
import znaishaded.io.vertx.ext.auth.htdigest.HtdigestAuth;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.handler.DigestAuthHandler;
import znaishaded.io.vertx.ext.web.handler.impl.AuthorizationAuthHandler;

public class DigestAuthHandlerImpl
extends AuthorizationAuthHandler
implements DigestAuthHandler {
    private static final Pattern PARSER = Pattern.compile("(\\w+)=[\"]?([^\"]*)[\"]?$");
    private static final Pattern SPLITTER = Pattern.compile(",(?=(?:[^\"]|\"[^\"]*\")*$)");
    private static final MessageDigest MD5;
    private final SecureRandom random = new SecureRandom();
    private final Map<String, Nonce> nonces = new HashMap<String, Nonce>();
    private final long nonceExpireTimeout;
    private long lastExpireRun;
    private static final char[] hexArray;

    public DigestAuthHandlerImpl(HtdigestAuth authProvider, long nonceExpireTimeout) {
        super((AuthProvider)authProvider, authProvider.realm(), AuthorizationAuthHandler.Type.DIGEST);
        this.nonceExpireTimeout = nonceExpireTimeout;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        long now = System.currentTimeMillis();
        if (now - this.lastExpireRun > this.nonceExpireTimeout / 2L) {
            this.nonces.entrySet().removeIf(entry -> ((Nonce)entry.getValue()).createdAt + this.nonceExpireTimeout < now);
            this.lastExpireRun = now;
        }
        this.parseAuthorization(context, false, parseAuthorization -> {
            String opaque;
            if (parseAuthorization.failed()) {
                handler.handle(Future.failedFuture(parseAuthorization.cause()));
                return;
            }
            JsonObject authInfo = new JsonObject();
            try {
                String[] tokens = SPLITTER.split((CharSequence)parseAuthorization.result());
                int len = tokens.length;
                for (int i = 0; i < len; ++i) {
                    Matcher m3 = PARSER.matcher(tokens[i]);
                    if (!m3.find()) continue;
                    authInfo.put(m3.group(1), m3.group(2));
                }
                String nonce = authInfo.getString("nonce");
                if (!this.nonces.containsKey(nonce)) {
                    handler.handle(Future.failedFuture(UNAUTHORIZED));
                    return;
                }
                if (authInfo.containsKey("qop")) {
                    Nonce n;
                    int nc = Integer.parseInt(authInfo.getString("nc"));
                    if (nc <= (n = this.nonces.get(nonce)).count) {
                        handler.handle(Future.failedFuture(UNAUTHORIZED));
                        return;
                    }
                    n.count = nc;
                }
            }
            catch (RuntimeException e) {
                handler.handle(Future.failedFuture(e));
            }
            Session session = context.session();
            if (session != null && (opaque = (String)session.data().get("opaque")) != null && !opaque.equals(authInfo.getString("opaque"))) {
                handler.handle(Future.failedFuture(UNAUTHORIZED));
                return;
            }
            authInfo.put("method", context.request().method().name());
            handler.handle(Future.succeededFuture(authInfo));
        });
    }

    @Override
    protected String authenticateHeader(RoutingContext context) {
        byte[] bytes = new byte[32];
        this.random.nextBytes(bytes);
        String nonce = DigestAuthHandlerImpl.md5(bytes);
        this.nonces.put(nonce, new Nonce());
        String opaque = null;
        Session session = context.session();
        if (session != null) {
            opaque = (String)session.data().get("opaque");
        }
        if (opaque == null) {
            this.random.nextBytes(bytes);
            opaque = DigestAuthHandlerImpl.md5(bytes);
        }
        return "Digest realm=\"" + this.realm + "\", qop=\"auth\", nonce=\"" + nonce + "\", opaque=\"" + opaque + "\"";
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static synchronized String md5(byte[] payload) {
        MD5.reset();
        return DigestAuthHandlerImpl.bytesToHex(MD5.digest(payload));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        hexArray = "0123456789abcdef".toCharArray();
    }

    private static class Nonce {
        private final long createdAt = System.currentTimeMillis();
        private int count = 0;

        Nonce() {
        }
    }
}

