/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;

public class OptionFlags {
    private static final OptionFlags singleton = new OptionFlags();
    public static boolean ALLOW_INCLUDE = true;
    public static final boolean USE_HECTOR = false;
    public static boolean ADD_NICE_FOR_DOT = false;
    public static final boolean STRICT_SELFMESSAGE_POSITION = true;
    public static final boolean FORCE_TEOZ = false;
    public static final boolean USE_INTERFACE_EYE1 = false;
    public static final boolean USE_INTERFACE_EYE2 = false;
    private boolean verbose;
    private boolean extractFromMetadata;
    private boolean word;
    private boolean systemExit;
    private boolean gui;
    private boolean quiet;
    private boolean checkDotError;
    private boolean printFonts;
    private boolean encodesprite;
    private boolean dumpHtmlStats;
    private boolean dumpStats;
    private boolean loopStats;
    private boolean overwrite;
    private boolean enableStats = OptionFlags.defaultForStats();
    private boolean stdLib;
    private boolean silentlyCompletelyIgnoreErrors;
    private boolean replaceWhiteBackgroundByTransparent;
    private boolean extractStdLib;
    private boolean clipboardLoop;
    private boolean clipboard;
    private String fileSeparator = "_";
    private long timeoutMs = 900000L;
    private SFile logData;
    private final AtomicBoolean logDataInitized = new AtomicBoolean(false);

    public static void setAllowIncludeFalse() {
        ALLOW_INCLUDE = false;
    }

    public static void setMaxPixel(int max) {
    }

    public void reset() {
        this.reset(false);
        GraphvizUtils.setDotExecutable(null);
    }

    public final void setDotExecutable(String dotExecutable) {
        GraphvizUtils.setDotExecutable(dotExecutable);
    }

    private OptionFlags() {
        this.reset(true);
    }

    private void reset(boolean exit) {
        this.verbose = false;
        this.extractFromMetadata = false;
        this.word = false;
        this.systemExit = exit;
        this.gui = false;
        this.quiet = false;
        this.checkDotError = false;
        this.printFonts = false;
        this.encodesprite = false;
    }

    public boolean useJavaInsteadOfDot() {
        return false;
    }

    public static OptionFlags getInstance() {
        return singleton;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public final boolean isExtractFromMetadata() {
        return this.extractFromMetadata;
    }

    public final void setExtractFromMetadata(boolean extractFromMetadata) {
        this.extractFromMetadata = extractFromMetadata;
    }

    public final boolean isWord() {
        return this.word;
    }

    public final void setWord(boolean word) {
        this.word = word;
    }

    public final boolean isSystemExit() {
        return this.systemExit;
    }

    public final void setSystemExit(boolean systemExit) {
        this.systemExit = systemExit;
    }

    public final boolean isGui() {
        return this.gui;
    }

    public final void setGui(boolean gui) {
        this.gui = gui;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public final boolean isCheckDotError() {
        return this.checkDotError;
    }

    public final void setCheckDotError(boolean checkDotError) {
        this.checkDotError = checkDotError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logData(SFile file, Diagram system) {
        String warnOrError = system.getWarningOrError();
        if (warnOrError == null) {
            return;
        }
        AtomicBoolean atomicBoolean = this.logDataInitized;
        synchronized (atomicBoolean) {
            if (this.logData == null && !this.logDataInitized.get()) {
                String s2 = GraphvizUtils.getenvLogData();
                if (s2 != null) {
                    this.setLogData(new SFile(s2));
                }
                this.logDataInitized.set(true);
            }
            if (this.logData == null) {
                return;
            }
            try (PrintStream ps = SecurityUtils.createPrintStream(this.logData.createFileOutputStream(true));){
                ps.println("Start of " + file.getName());
                ps.println(warnOrError);
                ps.println("End of " + file.getName());
                ps.println();
            }
            catch (FileNotFoundException e) {
                Log.error("Cannot open " + this.logData);
                e.printStackTrace();
            }
        }
    }

    public final void setLogData(SFile logData) {
        this.logData = logData;
        logData.delete();
        try (PrintStream ps = SecurityUtils.createPrintStream(logData.createFileOutputStream());){
            ps.println();
        }
        catch (FileNotFoundException e) {
            Log.error("Cannot open " + logData);
            e.printStackTrace();
        }
    }

    public final boolean isPrintFonts() {
        return this.printFonts;
    }

    public final void setPrintFonts(boolean printFonts) {
        this.printFonts = printFonts;
    }

    public final boolean isUseSuggestEngine2() {
        return false;
    }

    public final boolean isEncodesprite() {
        return this.encodesprite;
    }

    public final void setEncodesprite(boolean encodesprite) {
        this.encodesprite = encodesprite;
    }

    public final boolean isOverwrite() {
        return this.overwrite;
    }

    public final void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public final String getFileSeparator() {
        return this.fileSeparator;
    }

    public final void setFileSeparator(String fileSeparator) {
        this.fileSeparator = fileSeparator;
    }

    public final boolean isDumpHtmlStats() {
        return this.dumpHtmlStats;
    }

    public final void setDumpHtmlStats(boolean value) {
        this.dumpHtmlStats = value;
    }

    public final boolean isDumpStats() {
        return this.dumpStats;
    }

    public final void setDumpStats(boolean dumpStats) {
        this.dumpStats = dumpStats;
    }

    public final boolean isLoopStats() {
        return this.loopStats;
    }

    public final void setLoopStats(boolean loopStats) {
        this.loopStats = loopStats;
    }

    private static boolean defaultForStats() {
        return OptionFlags.isTrue(System.getProperty("PLANTUML_STATS")) || OptionFlags.isTrue(System.getenv("PLANTUML_STATS"));
    }

    private static boolean isTrue(String value) {
        return "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }

    public boolean isEnableStats() {
        return this.enableStats;
    }

    public void setEnableStats(boolean enableStats) {
        this.enableStats = enableStats;
    }

    public final long getTimeoutMs() {
        return this.timeoutMs;
    }

    public final void setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void setExtractStdLib(boolean extractStdLib) {
        this.extractStdLib = extractStdLib;
    }

    public boolean isExtractStdLib() {
        return this.extractStdLib;
    }

    public final boolean isClipboardLoop() {
        return this.clipboardLoop;
    }

    public final void setClipboardLoop(boolean clipboardLoop) {
        this.clipboardLoop = clipboardLoop;
    }

    public final boolean isClipboard() {
        return this.clipboard;
    }

    public final void setClipboard(boolean clipboard) {
        this.clipboard = clipboard;
    }

    public final boolean isStdLib() {
        return this.stdLib;
    }

    public final void setStdLib(boolean stdLib) {
        this.stdLib = stdLib;
    }

    public final boolean isSilentlyCompletelyIgnoreErrors() {
        return this.silentlyCompletelyIgnoreErrors;
    }

    public final void setSilentlyCompletelyIgnoreErrors(boolean silentlyCompletelyIgnoreErrors) {
        this.silentlyCompletelyIgnoreErrors = silentlyCompletelyIgnoreErrors;
    }

    public final boolean isReplaceWhiteBackgroundByTransparent() {
        return this.replaceWhiteBackgroundByTransparent;
    }

    public final void setReplaceWhiteBackgroundByTransparent(boolean replaceWhiteBackgroundByTransparent) {
        this.replaceWhiteBackgroundByTransparent = replaceWhiteBackgroundByTransparent;
    }
}

