/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;

public class UrlBuilder {
    private static final String S_QUOTED = "\\[\\[[%s]*[%g]([^%g]+)[%g](?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]";
    private static final String S_ONLY_TOOLTIP = "\\[\\[[%s]*\\{(.*)\\}[%s]*\\]\\]";
    private static final String S_ONLY_TOOLTIP_AND_LABEL = "\\[\\[[%s]*\\{([^{}]*)\\}[%s]*([^\\[%s\\{\\}\\[\\]][^\\[\\]]*)[%s]*\\]\\]";
    private static final String S_LINK_TOOLTIP_NOLABEL = "\\[\\[[%s]*([^\\s%g{}\\[\\]]+?)[%s]*\\{(.+)\\}[%s]*\\]\\]";
    private static final String S_LINK_WITH_OPTIONAL_TOOLTIP_WITH_OPTIONAL_LABEL = "\\[\\[[%s]*([^%s%g\\[\\]]+?)(?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]";
    private static final Pattern2 QUOTED = MyPattern.cmpile("\\[\\[[%s]*[%g]([^%g]+)[%g](?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]");
    private static final Pattern2 ONLY_TOOLTIP = MyPattern.cmpile("\\[\\[[%s]*\\{(.*)\\}[%s]*\\]\\]");
    private static final Pattern2 ONLY_TOOLTIP_AND_LABEL = MyPattern.cmpile("\\[\\[[%s]*\\{([^{}]*)\\}[%s]*([^\\[%s\\{\\}\\[\\]][^\\[\\]]*)[%s]*\\]\\]");
    private static final Pattern2 LINK_TOOLTIP_NOLABEL = MyPattern.cmpile("\\[\\[[%s]*([^\\s%g{}\\[\\]]+?)[%s]*\\{(.+)\\}[%s]*\\]\\]");
    private static final Pattern2 LINK_WITH_OPTIONAL_TOOLTIP_WITH_OPTIONAL_LABEL = MyPattern.cmpile("\\[\\[[%s]*([^%s%g\\[\\]]+?)(?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]");
    private final String topurl;
    private UrlMode mode;

    public static String getRegexp() {
        return "\\[\\[[%s]*[%g]([^%g]+)[%g](?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]|\\[\\[[%s]*\\{(.*)\\}[%s]*\\]\\]|\\[\\[[%s]*\\{([^{}]*)\\}[%s]*([^\\[%s\\{\\}\\[\\]][^\\[\\]]*)[%s]*\\]\\]|\\[\\[[%s]*([^\\s%g{}\\[\\]]+?)[%s]*\\{(.+)\\}[%s]*\\]\\]|\\[\\[[%s]*([^%s%g\\[\\]]+?)(?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]";
    }

    public UrlBuilder(String topurl, UrlMode mode) {
        this.topurl = topurl;
        this.mode = mode;
    }

    public Url getUrl(String s2) {
        Matcher2 m3 = QUOTED.matcher(s2);
        if (this.matchesOrFind(m3)) {
            return new Url(this.withTopUrl(m3.group(1)), m3.group(2), m3.group(3));
        }
        m3 = ONLY_TOOLTIP.matcher(s2);
        if (this.matchesOrFind(m3)) {
            return new Url("", m3.group(1), null);
        }
        m3 = ONLY_TOOLTIP_AND_LABEL.matcher(s2);
        if (this.matchesOrFind(m3)) {
            return new Url("", m3.group(1), m3.group(2));
        }
        m3 = LINK_TOOLTIP_NOLABEL.matcher(s2);
        if (this.matchesOrFind(m3)) {
            return new Url(this.withTopUrl(m3.group(1)), m3.group(2), null);
        }
        m3 = LINK_WITH_OPTIONAL_TOOLTIP_WITH_OPTIONAL_LABEL.matcher(s2);
        if (this.matchesOrFind(m3)) {
            return new Url(this.withTopUrl(m3.group(1)), m3.group(2), m3.group(3));
        }
        return null;
    }

    private boolean matchesOrFind(Matcher2 m3) {
        if (this.mode == UrlMode.STRICT) {
            return m3.matches();
        }
        if (this.mode == UrlMode.ANYWHERE) {
            return m3.find();
        }
        throw new IllegalStateException();
    }

    private String withTopUrl(String url) {
        if (!(url.startsWith("http:") || url.startsWith("https:") || url.startsWith("file:") || this.topurl == null)) {
            return this.topurl + url;
        }
        return url;
    }
}

