/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram.command;

import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import znaishaded.net.sourceforge.plantuml.activitydiagram.command.CommandLinkActivity;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;

public class CommandIf
extends SingleLineCommand2<ActivityDiagram> {
    public CommandIf() {
        super(CommandIf.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandIf.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexOr("FIRST", new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([%pLN_.]+)"), new RegexLeaf("BAR", "(?:==+)[%s]*([%pLN_.]+)[%s]*(?:==+)"), new RegexLeaf("QUOTED", "[%g]([^%g]+)[%g](?:[%s]+as[%s]+([%pLN_.]+))?"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("ARROW_BODY1", "([-.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(\\*|left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-.]*)"), new RegexLeaf("\\>"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("BRACKET", "\\[([^\\]*]+[^\\]]*)\\]")), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf("IF1", "if[%s]*[%g]([^%g]*)[%g][%s]*(?:as[%s]+([%pLN_.]+)[%s]+)?"), new RegexLeaf("IF2", "if[%s]+(.+?)")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("then")), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram diagram, LineLocation location, RegexResult arg) {
        Direction direction;
        String ifLabel;
        String ifCode;
        IEntity entity1 = CommandLinkActivity.getEntity(diagram, arg, true);
        if (entity1 == null) {
            return CommandExecutionResult.error("No if possible at this point");
        }
        if (arg.get("IF2", 0) == null) {
            ifCode = arg.get("IF1", 1);
            ifLabel = arg.get("IF1", 0);
        } else {
            ifCode = null;
            ifLabel = arg.get("IF2", 0);
        }
        diagram.startIf(ifCode);
        int lenght = 2;
        if (arg.get("ARROW_BODY1", 0) != null) {
            String arrowBody1 = CommandLinkClass.notNull(arg.get("ARROW_BODY1", 0));
            String arrowBody2 = CommandLinkClass.notNull(arg.get("ARROW_BODY2", 0));
            String arrowDirection = CommandLinkClass.notNull(arg.get("ARROW_DIRECTION", 0));
            String arrow = StringUtils.manageArrowForCuca(arrowBody1 + arrowDirection + arrowBody2 + ">");
            lenght = arrow.length() - 1;
        }
        IEntity branch = diagram.getCurrentContext().getBranch();
        Link link = new Link(entity1, branch, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), Display.getWithNewlines(arg.get("BRACKET", 0)), lenght, null, ifLabel, diagram.getLabeldistance(), diagram.getLabelangle(), diagram.getSkinParam().getCurrentStyleBuilder());
        if (arg.get("ARROW", 0) != null && ((direction = StringUtils.getArrowDirection(arg.get("ARROW", 0))) == Direction.LEFT || direction == Direction.UP)) {
            link = link.getInv();
        }
        link.applyStyle(diagram.getSkinParam().getThemeStyle(), arg.getLazzy("ARROW_STYLE", 0));
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

