/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.command;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandArrowLong3
extends CommandMultilines2<ActivityDiagram3> {
    public CommandArrowLong3() {
        super(CommandArrowLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "^(.*);$";
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandArrowLong3.class.getName(), RegexLeaf.start(), new RegexOr(new RegexLeaf("->"), new RegexLeaf("COLOR", "-\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*)*)\\]->")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("LABEL", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(ActivityDiagram3 diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.removeEmptyColumns();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String colorString = line0.get("COLOR", 0);
        if (colorString != null) {
            Rainbow rainbow = Rainbow.build(diagram.getSkinParam(), colorString, diagram.getSkinParam().colorArrowSeparationSpace());
            diagram.setColorNextArrow(rainbow);
        }
        lines = lines.removeStartingAndEnding(line0.get("LABEL", 0), 1);
        diagram.setLabelNextArrow(lines.toDisplay());
        return CommandExecutionResult.ok();
    }

    private <CS extends CharSequence> void removeStarting(List<CS> lines, String data) {
        if (lines.size() == 0) {
            return;
        }
        lines.set(0, data);
    }

    private <CS extends CharSequence> void removeEnding(List<CS> lines) {
        if (lines.size() == 0) {
            return;
        }
        int n = lines.size() - 1;
        CharSequence s2 = (CharSequence)lines.get(n);
        lines.set(n, s2.subSequence(0, s2.length() - 1));
    }
}

