/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEmpty;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class LaneDivider
extends AbstractTextBlock {
    private final ISkinParam skinParam;
    private final double x1;
    private final double x2;
    private final double height;
    private Style style;

    public LaneDivider(ISkinParam skinParam, double x1, double x2, double height) {
        this.skinParam = skinParam;
        this.x1 = x1;
        this.x2 = x2;
        this.height = height;
    }

    public StyleSignatureBasic getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.swimlane);
    }

    private Style getStyle() {
        if (this.style == null) {
            this.style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        }
        return this.style;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.x1 + this.x2, this.height);
    }

    @Override
    public void drawU(UGraphic ug) {
        UEmpty back = new UEmpty(this.x1 + this.x2, 1.0);
        ug.draw(back);
        HColor color = this.getStyle().value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        UStroke thickness = this.getStyle().getStroke();
        ug.apply(UTranslate.dx(this.x1)).apply(thickness).apply(color).draw(ULine.vline(this.height));
    }

    public double getWidth() {
        return this.x1 + this.x2;
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getX2() {
        return this.x2;
    }
}

