/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.board;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import znaishaded.net.sourceforge.plantuml.board.BArray;

public class BNode {
    private final String name;
    private final int stage;
    private int x = -1;
    private BNode parent;
    private final List<BNode> children = new ArrayList<BNode>();

    public BNode(int stage, String name) {
        this.name = name;
        this.stage = stage;
    }

    public void addChild(BNode child) {
        if (child.stage <= this.stage) {
            throw new IllegalArgumentException();
        }
        this.children.add(child);
        if (child.parent != null) {
            throw new IllegalArgumentException();
        }
        child.parent = this;
    }

    public final String getName() {
        return this.name;
    }

    public final int getStage() {
        return this.stage;
    }

    public final BNode getParent() {
        return this.parent;
    }

    public String toString() {
        return this.name + "(" + this.stage + ") [" + this.x + "]";
    }

    public void computeX(AtomicInteger count) {
        this.x = count.intValue();
        for (int i = 0; i < this.children.size(); ++i) {
            BNode child = this.children.get(i);
            if (i > 0) {
                count.addAndGet(1);
            }
            child.computeX(count);
        }
    }

    public void initBarray(BArray array) {
        array.put(this);
        for (BNode child : this.children) {
            child.initBarray(array);
        }
    }

    public final int getX() {
        return this.x;
    }
}

