/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CommandHeader
extends SingleLineCommand2<TitledDiagram> {
    public CommandHeader() {
        super(CommandHeader.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandHeader.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexLeaf("POSITION", "(left|right|center)")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("header"), new RegexOr(new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore()), RegexLeaf.spaceOneOrMore()), new RegexOr(new RegexLeaf("LABEL1", "[%g](.*)[%g]"), new RegexLeaf("LABEL2", "(.*[%pLN_.].*)")), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram diagram, LineLocation location, RegexResult arg) {
        String align = arg.get("POSITION", 0);
        HorizontalAlignment ha = HorizontalAlignment.fromString(align, HorizontalAlignment.RIGHT);
        if (align == null) {
            ha = FontParam.HEADER.getStyleDefinition(null).getMergedStyle(diagram.getCurrentStyleBuilder()).getHorizontalAlignment();
        }
        Display s2 = Display.getWithNewlines(arg.getLazzy("LABEL", 0));
        diagram.getHeader().putDisplay(s2, ha);
        return CommandExecutionResult.ok();
    }
}

