/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public abstract class CommandMultilines2<S extends Diagram>
implements Command<S> {
    private final IRegex starting;
    private final MultilinesStrategy strategy;

    public CommandMultilines2(IRegex patternStart, MultilinesStrategy strategy) {
        if (!patternStart.getPattern().startsWith("^") || !patternStart.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + patternStart.getPattern());
        }
        this.strategy = strategy;
        this.starting = patternStart;
    }

    public boolean syntaxWithFinalBracket() {
        return false;
    }

    public abstract String getPatternEnd();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.getPattern(), "END: " + this.getPatternEnd()};
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        StringLocated first;
        lines = lines.cleanList(this.strategy);
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        if (this.syntaxWithFinalBracket()) {
            if (lines.size() == 1 && !lines.getFirst().getTrimmed().getString().endsWith("{")) {
                String vline = lines.getAt(0).getString() + " {";
                if (this.isValid(BlocLines.singleString(vline)) == CommandControl.OK_PARTIAL) {
                    return CommandControl.OK_PARTIAL;
                }
                return CommandControl.NOT_OK;
            }
            lines = lines.eventuallyMoveBracket();
        }
        if ((first = lines.getFirst()) == null) {
            return CommandControl.NOT_OK;
        }
        boolean result1 = this.starting.match(first.getTrimmed());
        if (!result1) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        Matcher2 m1 = MyPattern.cmpile(this.getPatternEnd()).matcher(lines.getLast().getTrimmed().getString());
        if (!m1.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        return this.finalVerification(lines);
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines) {
        lines = lines.cleanList(this.strategy);
        if (this.syntaxWithFinalBracket()) {
            lines = lines.eventuallyMoveBracket();
        }
        try {
            return this.executeNow(system, lines);
        }
        catch (NoSuchColorException e) {
            return CommandExecutionResult.badColor();
        }
    }

    protected abstract CommandExecutionResult executeNow(S var1, BlocLines var2) throws NoSuchColorException;

    protected boolean isCommandForbidden() {
        return false;
    }

    protected CommandControl finalVerification(BlocLines lines) {
        return CommandControl.OK;
    }

    protected final IRegex getStartingPattern() {
        return this.starting;
    }
}

