/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.ErrorUmlType;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.command.PSystemAbstractFactory;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.error.PSystemErrorUtils;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class PSystemBasicFactory<P extends AbstractPSystem>
extends PSystemAbstractFactory {
    public PSystemBasicFactory(DiagramType diagramType) {
        super(diagramType);
    }

    public PSystemBasicFactory() {
        this(DiagramType.UML);
    }

    public abstract P executeLine(ThemeStyle var1, UmlSource var2, P var3, String var4);

    public abstract P initDiagram(ThemeStyle var1, UmlSource var2, String var3);

    private boolean isEmptyLine(StringLocated result) {
        return result.getTrimmed().getString().length() == 0;
    }

    @Override
    public final Diagram createSystem(ThemeStyle style, UmlSource source, ISkinSimple skinParam) {
        source = source.removeInitialSkinparam();
        IteratorCounter2 it = source.iterator2();
        StringLocated startLine = (StringLocated)it.next();
        P system = this.initDiagram(style, source, startLine.getString());
        boolean first = true;
        while (it.hasNext()) {
            StringLocated s2 = (StringLocated)it.next();
            if (first && s2 != null && this.isEmptyLine(s2)) continue;
            first = false;
            if (StartUtils.isArobaseEndDiagram(s2.getString())) {
                if (source.getTotalLineCount() == 2 && !source.isStartDef()) {
                    return this.buildEmptyError(source, s2.getLocation(), it.getTrace());
                }
                return system;
            }
            if ((system = this.executeLine(style, source, system, s2.getString())) != null) continue;
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", 0, s2.getLocation());
            return PSystemErrorUtils.buildV2(source, err, null, it.getTrace());
        }
        return system;
    }
}

