/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.regex;

import java.util.Map;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.command.regex.MaxSizeHashMap;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;

public abstract class MyPattern {
    private static final Map<String, Pattern2> cache = new MaxSizeHashMap<String, Pattern2>(512);
    private static final Pattern2 EMPTY = new Pattern2(Pattern.compile(""));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern2 cmpile(String p) {
        if (p == null || p.length() == 0) {
            return EMPTY;
        }
        Pattern2 result = null;
        Map<String, Pattern2> map = cache;
        synchronized (map) {
            result = cache.get(p);
            if (result != null) {
                return result;
            }
        }
        assert (result == null);
        result = new Pattern2(Pattern.compile(MyPattern.transform(p), 2));
        map = cache;
        synchronized (map) {
            cache.put(p, result);
        }
        return result;
    }

    private static String transform(String p) {
        p = p.replace("%pLN", "\\p{L}0-9");
        p = p.replace("%s", "\\s\u00a0");
        p = p.replace("%q", "'\u2018\u2019");
        p = p.replace("%g", "\"\u201c\u201d\u00ab\u00bb");
        return p;
    }

    public static boolean mtches(CharSequence input, String regex) {
        return MyPattern.cmpile(regex).matcher(input).matches();
    }

    public static CharSequence removeAll(CharSequence src, String regex) {
        return src.toString().replaceAll(MyPattern.transform(regex), "");
    }
}

