/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.compositediagram.command;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.compositediagram.CompositeDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;

public class CommandLinkBlock
extends SingleLineCommand2<CompositeDiagram> {
    public CommandLinkBlock() {
        super(CommandLinkBlock.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandLinkBlock.class.getName(), RegexLeaf.start(), new RegexLeaf("ENT1", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DECO1", "(\\[\\]|\\*\\))?"), new RegexLeaf("QUEUE", "([=-]+|\\.+)"), new RegexLeaf("DECO2", "(\\[\\]|\\(\\*)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ENT2", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DISPLAY", "(\\S*+)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(CompositeDiagram diagram, LineLocation location, RegexResult arg) {
        String ent1 = arg.get("ENT1", 0);
        String ent2 = arg.get("ENT2", 0);
        IEntity cl1 = diagram.getOrCreateLeaf(diagram.buildLeafIdent(ent1), diagram.buildCode(ent1), null, null);
        IEntity cl2 = diagram.getOrCreateLeaf(diagram.buildLeafIdent(ent2), diagram.buildCode(ent2), null, null);
        String deco1 = arg.get("DECO1", 0);
        String deco2 = arg.get("DECO2", 0);
        LinkType linkType = new LinkType(this.getLinkDecor(deco1), this.getLinkDecor(deco2));
        String queue = arg.get("QUEUE", 0);
        Link link = new Link(cl1, cl2, linkType, Display.getWithNewlines(arg.get("DISPLAY", 0)), queue.length(), diagram.getSkinParam().getCurrentStyleBuilder());
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private LinkDecor getLinkDecor(String s2) {
        if ("[]".equals(s2)) {
            return LinkDecor.SQUARE_toberemoved;
        }
        return LinkDecor.NONE;
    }
}

