/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.command;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.SvgAttributes;

public class CommandCreoleSvgAttributeChange
implements Command {
    public static final String fontPattern = "\\<text[\\s:]+([^>]+)/?\\>";
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<text[\\s:]+([^>]+)/?\\>(.*?)\\</text\\>)");
    private static final Pattern2 patternEol = MyPattern.cmpile("^(\\<text[\\s:]+([^>]+)/?\\>(.*))$");
    private final Pattern2 mypattern;

    @Override
    public String startingChars() {
        return "<";
    }

    public static Command create() {
        return new CommandCreoleSvgAttributeChange(pattern);
    }

    public static Command createEol() {
        return new CommandCreoleSvgAttributeChange(patternEol);
    }

    private CommandCreoleSvgAttributeChange(Pattern2 p) {
        this.mypattern = p;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        FontConfiguration fc1;
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc2 = fc1 = stripe.getActualFontConfiguration();
        if (m3.group(2) != null) {
            fc2 = fc2.changeAttributes(new SvgAttributes(m3.group(2)));
        }
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m3.group(3));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m3.group(1).length());
    }
}

