/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.legacy;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.EmbeddedDiagram;
import znaishaded.net.sourceforge.plantuml.EmbeddedDiagramDraw;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBuilder;
import znaishaded.net.sourceforge.plantuml.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.creole.legacy.CreoleStripeSimpleParser;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeCode;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeTable;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeTree;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorRuntimeException;

public class CreoleParser
implements SheetBuilder {
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final HorizontalAlignment horizontalAlignment;
    private final CreoleMode creoleMode;
    private final FontConfiguration stereotype;

    public CreoleParser(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple skinParam, CreoleMode creoleMode, FontConfiguration stereotype) {
        this.stereotype = stereotype;
        this.creoleMode = creoleMode;
        this.fontConfiguration = fontConfiguration;
        this.skinParam = Objects.requireNonNull(skinParam);
        this.horizontalAlignment = horizontalAlignment;
    }

    private Stripe createStripe(String line, CreoleContext context, Stripe lastStripe, FontConfiguration fontConfiguration) {
        if (lastStripe instanceof StripeCode) {
            StripeCode code = (StripeCode)lastStripe;
            if (code.isTerminated()) {
                lastStripe = null;
            } else {
                boolean terminated = code.addAndCheckTermination(line);
                return null;
            }
        }
        if (lastStripe instanceof StripeTable && CreoleParser.isTableLine(line)) {
            StripeTable table = (StripeTable)lastStripe;
            table.analyzeAndAddLine(line);
            return null;
        }
        if (lastStripe instanceof StripeTree && Parser.isTreeStart(StringUtils.trinNoTrace(line))) {
            StripeTree tree = (StripeTree)lastStripe;
            tree.analyzeAndAdd(line);
            return null;
        }
        if (CreoleParser.isTableLine(line)) {
            return new StripeTable(fontConfiguration, this.skinParam, line);
        }
        if (Parser.isTreeStart(line)) {
            return new StripeTree(fontConfiguration, this.skinParam, line);
        }
        if (Parser.isCodeStart(line)) {
            return new StripeCode(fontConfiguration.changeFamily("monospaced"), this.skinParam, line);
        }
        return new CreoleStripeSimpleParser(line, context, fontConfiguration, this.skinParam, this.creoleMode).createStripe(context);
    }

    public static boolean isTableLine(String line) {
        return line.matches("^(\\<#\\w+(,#?\\w+)?\\>)?\\|(\\=)?.*\\|$");
    }

    public static boolean doesStartByColor(String line) {
        return line.matches("^\\=?\\s*(\\<#\\w+(,#?\\w+)?\\>).*");
    }

    @Override
    public Sheet createSheet(Display display) {
        Sheet sheet = new Sheet(this.horizontalAlignment);
        if (!Display.isNull(display)) {
            CreoleContext context = new CreoleContext();
            for (CharSequence cs : display) {
                Stripe stripe;
                if (cs instanceof EmbeddedDiagram) {
                    final EmbeddedDiagramDraw atom = ((EmbeddedDiagram)cs).asDraw(this.skinParam);
                    stripe = new Stripe(){

                        @Override
                        public Atom getLHeader() {
                            return null;
                        }

                        @Override
                        public List<Atom> getAtoms() {
                            return Arrays.asList(atom);
                        }
                    };
                } else {
                    if (cs instanceof Stereotype) {
                        if (!display.showStereotype()) continue;
                        for (String st : ((Stereotype)cs).getLabels(this.skinParam.guillemet())) {
                            sheet.add(this.createStripe(st, context, sheet.getLastStripe(), this.stereotype));
                        }
                        continue;
                    }
                    stripe = this.createStripe(cs.toString(), context, sheet.getLastStripe(), this.fontConfiguration);
                }
                if (stripe == null) continue;
                sheet.add(stripe);
            }
        }
        return sheet;
    }

    public static void checkColor(Display result) throws NoSuchColorException {
        FontConfiguration fc = FontConfiguration.blackBlueTrue(UFont.byDefault(10));
        try {
            new CreoleParser(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty(), CreoleMode.FULL, fc).createSheet(result);
        }
        catch (NoSuchColorRuntimeException e) {
            throw new NoSuchColorException();
        }
    }
}

